"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySerializer = exports.parseMessage = void 0;
function parseMessage(messageString) {
    try {
        const message = JSON.parse(messageString);
        return typeof message === 'object' ? message : null;
    }
    catch (error) {
        // failed to parse so it's not a Message and we can ignore it
        return null;
    }
}
exports.parseMessage = parseMessage;
exports.IdentitySerializer = {
    serialize: (object) => object,
    deserialize: (message) => message,
};
//# sourceMappingURL=serialization.js.map