"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PeerNetwork = void 0;
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const lockedDecorator_1 = require("@signageos/lib/es6/Lock/lockedDecorator");
const debugDecorator_1 = require("@signageos/lib/es6/Debug/debugDecorator");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const ITcpSocket_1 = require("./Socket/Tcp/ITcpSocket");
const IPeerNetwork_1 = require("./IPeerNetwork");
const IPeerDiscoveryService_1 = require("./PeerDiscoveryService/IPeerDiscoveryService");
const DEBUG_NAMESPACE = '@signageos/front-display:PeerNetwork:PeerNetwork';
const logDebug = (0, debug_1.default)(DEBUG_NAMESPACE);
class PeerNetwork {
    constructor(peerDiscoveryService, createSocket) {
        this.peerDiscoveryService = peerDiscoveryService;
        this.createSocket = createSocket;
        this.emitter = new events_1.EventEmitter();
        this.socket = null;
        this.started = false;
        this.handlePeersChanged = this.handlePeersChanged.bind(this);
        this.handleSocketMessage = this.handleSocketMessage.bind(this);
        this.handleSocketClosed = this.handleSocketClosed.bind(this);
        this.listenToPeerChanges();
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.started) {
                throw new Error('PeerNetwork already started');
            }
            yield this.peerDiscoveryService.start();
            this.socket = yield this.openSocket();
            this.started = true;
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.peerDiscoveryService.isStarted()) {
                yield this.peerDiscoveryService.stop();
            }
            if (this.socket) {
                yield this.closeSocket(this.socket);
                this.socket = null;
            }
            this.started = false;
        });
    }
    isStarted() {
        return this.started;
    }
    getMe() {
        const me = this.peerDiscoveryService.getMe();
        return {
            id: me.id,
            aliveAt: me.aliveAt,
        };
    }
    getPeers() {
        const peers = this.peerDiscoveryService.getPeers();
        return peers.map((peer) => ({
            id: peer.id,
            aliveAt: peer.aliveAt,
        }));
    }
    send(message) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.socket) {
                throw new Error('PeerNetwork is not started');
            }
            const fullMessage = {
                fromId: this.getMe().id,
                message,
            };
            const peers = this.peerDiscoveryService.getPeers();
            // send to all peers
            yield Promise.all(peers.map((peer) => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield retry({
                        callback: () => this.socket.send({
                            host: peer.address,
                            port: peer.port,
                            message: fullMessage,
                        }),
                        attempts: 3,
                        delayBetweenAttemptsMs: 10,
                    });
                }
                catch (error) {
                    // ignore failures because we don't care if some peers are not reachable, show must go on
                    console.error(`failed to send message to ${peer.address}:${peer.port}`, error);
                }
            })));
        });
    }
    addListener(event, callback) {
        this.emitter.addListener(event, callback);
    }
    removeListener(event, callback) {
        this.emitter.removeListener(event, callback);
    }
    listenToPeerChanges() {
        this.peerDiscoveryService.addListener(IPeerDiscoveryService_1.PeerDiscoveryServiceEvent.PeersChanged, this.handlePeersChanged);
    }
    handlePeersChanged() {
        logDebug('peers changed');
        this.emitter.emit(IPeerNetwork_1.PeerNetworkEvent.PeersChanged);
    }
    openSocket() {
        return __awaiter(this, void 0, void 0, function* () {
            const socket = yield this.createSocket();
            socket.addListener(ITcpSocket_1.TcpSocketEvent.Message, this.handleSocketMessage);
            socket.addListener(ITcpSocket_1.TcpSocketEvent.Closed, this.handleSocketClosed);
            return socket;
        });
    }
    closeSocket(socket) {
        return __awaiter(this, void 0, void 0, function* () {
            socket.removeListener(ITcpSocket_1.TcpSocketEvent.Message, this.handleSocketMessage);
            socket.removeListener(ITcpSocket_1.TcpSocketEvent.Closed, this.handleSocketClosed);
            yield socket.close();
        });
    }
    handleSocketMessage(message) {
        if ((0, IPeerNetwork_1.isPeerNetworkMessage)(message)) {
            this.emitter.emit(IPeerNetwork_1.PeerNetworkEvent.Message, message);
        }
    }
    handleSocketClosed(error) {
        return __awaiter(this, void 0, void 0, function* () {
            logDebug('socket closed', error);
            yield this.stop();
            this.emitter.emit(IPeerNetwork_1.PeerNetworkEvent.Closed, error);
        });
    }
}
exports.PeerNetwork = PeerNetwork;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('peer_network', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PeerNetwork.prototype, "start", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('peer_network', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PeerNetwork.prototype, "stop", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PeerNetwork.prototype, "send", null);
function retry({ callback, attempts, delayBetweenAttemptsMs, }) {
    return __awaiter(this, void 0, void 0, function* () {
        let lastError;
        for (let i = 0; i < attempts; i++) {
            try {
                yield callback();
                return;
            }
            catch (error) {
                lastError = error;
                yield (0, wait_1.default)(delayBetweenAttemptsMs);
            }
        }
        throw lastError;
    });
}
//# sourceMappingURL=PeerNetwork.js.map