import { IUdpSocket } from '../Socket/Udp/IUdpSocket';
declare enum MessageType {
    Query = "query",
    Announce = "announce",
    Renounce = "renounce",
    Ping = "ping"
}
interface BaseMessage {
    sourceId: string;
    type: MessageType;
}
export interface QueryMessage extends BaseMessage {
    type: MessageType.Query;
}
export interface AnnounceMessage extends BaseMessage {
    type: MessageType.Announce;
    address: string;
    port: number;
}
export interface RenounceMessage extends BaseMessage {
    type: MessageType.Renounce;
}
export interface PingMessage extends BaseMessage {
    type: MessageType.Ping;
}
/**
 * Companion class to PeerDiscoveryService that handles sending messages.
 */
export declare class PeerDiscoveryServiceMessageSender {
    private id;
    private udpSocketFactory;
    private emitter;
    private socket;
    constructor(id: string, udpSocketFactory: () => Promise<IUdpSocket<object>>);
    setId(id: string): void;
    start(): Promise<void>;
    stop(): Promise<void>;
    isStarted(): boolean;
    onQuery(callback: (message: QueryMessage) => void): void;
    sendQuery(): Promise<void>;
    onAnnounce(callback: (message: AnnounceMessage) => void): void;
    sendAnnounce(address: string, port: number): Promise<void>;
    onRenounce(callback: (message: RenounceMessage) => void): void;
    sendRenounce(): Promise<void>;
    onPing(callback: (message: PingMessage) => void): void;
    sendPing(): Promise<void>;
    private handleMessage;
    private sendMessage;
}
export {};
