import { IPeerDiscoveryService, PeerDiscoveryPeer, PeerDiscoveryServiceEvent, PeersChangedCallback } from './IPeerDiscoveryService';
import { IUdpSocket } from '../Socket/Udp/IUdpSocket';
import { NetworkInfo } from './INetworkInfo';
export interface PeerDiscoveryServiceConfig {
    pingIntervalMs: number;
    cleanDeadPeersIntervalMs: number;
    aliveTimeout: number;
}
/**
 * Handles discovery of other peers in the network and communication with them.
 */
export declare class PeerDiscoveryService implements IPeerDiscoveryService {
    private id;
    private socketFactory;
    private getNetworkInfo;
    private config;
    private peers;
    private emitter;
    private messageHandler;
    private pingInterval;
    private cleanInterval;
    constructor(id: string, socketFactory: () => Promise<IUdpSocket<object>>, getNetworkInfo: () => Promise<NetworkInfo | null>, config?: Partial<PeerDiscoveryServiceConfig>);
    start(): Promise<void>;
    stop(): Promise<void>;
    isStarted(): boolean;
    getMe(): {
        id: string;
        aliveAt: Date;
    };
    getPeers(): PeerDiscoveryPeer[];
    addListener(event: PeerDiscoveryServiceEvent.PeersChanged, callback: PeersChangedCallback): void;
    removeListener(event: PeerDiscoveryServiceEvent.PeersChanged, callback: PeersChangedCallback): void;
    private registerMessageHandlerListeners;
    private handleQueryMessage;
    private handleAnnounceMessage;
    private handleRenounce;
    private handlePingMessage;
    private cleanDeadPeers;
}
