"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.offlineActionsSaga = exports.offlineActionFile = void 0;
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const offlineActions_1 = require("@signageos/actions/dist/Offline/offlineActions");
const effects_1 = require("redux-saga/effects");
const offlineActions_2 = require("./offlineActions");
const periodicTaskSaga_1 = require("../Saga/periodicTaskSaga");
const OfflineActionsUploader_1 = require("./OfflineActionsUploader");
const dependencyInjection_1 = require("../DI/dependencyInjection");
const socketActionDeliverHelper_1 = require("../Socket/socketActionDeliverHelper");
const systemLogActions_1 = require("@signageos/actions/dist/SystemLog/systemLogActions");
const ThrottledActionsChecker_1 = require("../Socket/ThrottledActionsChecker");
const ACTIONS_TO_SAVE = [activeAppletActions_1.ActiveAppletDispatchCommand, systemLogActions_1.SystemLog];
exports.offlineActionFile = 'offlineActions';
function* offlineActionsSaga(fileNamePrefix, getNativeDriver, getManagementDriver, options) {
    const uploader = new OfflineActionsUploader_1.OfflineActionsUploader(fileNamePrefix, getManagementDriver().fileSystem);
    const { offlineActionsLimits } = yield (0, dependencyInjection_1.awaitDependencies)(['offlineActionsLimits']);
    const actionChecker = new ThrottledActionsChecker_1.ThrottledActionsChecker(uploader, offlineActionsLimits);
    const deviceUid = yield getNativeDriver().getDeviceUid();
    yield (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['uploadBaseUrl'], function* ({ uploadBaseUrl }) {
        var _a, _b;
        yield (0, periodicTaskSaga_1.runPeriodicTaskSagaWhilePlatform)((_a = options === null || options === void 0 ? void 0 : options.initDelayMs) !== null && _a !== void 0 ? _a : 60e3, (_b = options === null || options === void 0 ? void 0 : options.periodMs) !== null && _b !== void 0 ? _b : 60e3, function* () {
            yield uploadOfflineActions(uploader, exports.offlineActionFile, deviceUid, uploadBaseUrl);
        }, { randomize: true });
    }));
    yield (0, effects_1.takeEvery)(offlineActions_2.SaveOfflineAction, function* (action) {
        try {
            if (ACTIONS_TO_SAVE.includes(action.action.type)) {
                yield actionChecker.addActionOrPass(action.action);
            }
        }
        catch (e) {
            console.error(`offline action ${action.action.type} failed`, e);
        }
    });
}
exports.offlineActionsSaga = offlineActionsSaga;
function* uploadOfflineActions(uploader, fileName, deviceUid, uploadBaseUrl) {
    try {
        const response = yield uploader.upload(deviceUid, fileName, uploadBaseUrl);
        if (response !== null) {
            if (response !== OfflineActionsUploader_1.NO_FILE) {
                try {
                    const { uri } = JSON.parse(response);
                    yield (0, socketActionDeliverHelper_1.deliver)({
                        type: offlineActions_1.SaveOfflineActionsFile,
                        actionType: systemLogActions_1.SystemLog,
                        fileUri: uri,
                    });
                }
                catch (e) {
                    console.error(`upload offline actions file ${fileName} failed: expected JSON response`, e);
                }
            }
        }
        else {
            console.error(`upload offline actions file ${fileName} failed: didn\'t get a response`);
        }
    }
    catch (e) {
        console.error(`upload offline actions file ${fileName} failed`, e);
    }
}
//# sourceMappingURL=offlineActionsSagas.js.map