"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OfflineActionsUploader = exports.NO_FILE = void 0;
const lodash_1 = __importDefault(require("lodash"));
const path_1 = __importDefault(require("path"));
const lockedDecorator_1 = require("../Lock/lockedDecorator");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const offlineActionsSagas_1 = require("./offlineActionsSagas");
const systemLogActions_1 = require("@signageos/actions/dist/SystemLog/systemLogActions");
const OFFLINE_DIR = '.offline-actions';
const LOCK_KEY = 'OfflineActionsUploader';
const DEBUG_NAMESPACE = '@signageos/front-display:Offline:OfflineActionsUploader';
const REFRESH_SPACE_INTERVAL = 60e3; // 1 minute
const MINIMAL_STORAGE_FREE_SPACE = 50 * 1024;
const FRONT_FILE = 'front';
const MANAGEMENT_FILE = 'management';
exports.NO_FILE = 'no_file_for_upload';
class OfflineActionsUploader {
    constructor(fileNamePrefix, fileSystem) {
        this.fileNamePrefix = fileNamePrefix;
        this.fileSystem = fileSystem;
    }
    addAction(action) {
        return __awaiter(this, void 0, void 0, function* () {
            this.start();
            if (this.deviceFreeSpace && this.deviceFreeSpace < MINIMAL_STORAGE_FREE_SPACE) {
                console.warn('No space for saving offline actions');
            }
            else {
                yield this.ensureOfflineDir();
                const appletCommandsFilePath = yield this.getFilePath(offlineActionsSagas_1.offlineActionFile, this.getFileNumber());
                yield this.fileSystem.appendFile(appletCommandsFilePath, this.actionToFileEntry(action));
            }
        });
    }
    upload(deviceUid, fileName, baseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            const filePath = yield this.getFilePathUpload(fileName);
            if (yield this.fileSystem.exists(filePath)) {
                const uploadUri = this.getUploadUri(baseUrl, deviceUid);
                const response = yield this.fileSystem.uploadFile(filePath, uploadUri, 'file');
                if (response === null || response === void 0 ? void 0 : response.includes(systemLogActions_1.SystemLog)) {
                    yield this.fileSystem.deleteFile(filePath, false);
                    return response;
                }
                else {
                    return response;
                }
            }
            else {
                this.stop();
                return exports.NO_FILE;
            }
        });
    }
    ensureOfflineDir() {
        return __awaiter(this, void 0, void 0, function* () {
            const offlineDirPath = yield this.getOfflineDirFilePath();
            yield this.ensureDir(offlineDirPath);
        });
    }
    ensureDir(dirPath) {
        return __awaiter(this, void 0, void 0, function* () {
            if (yield this.fileSystem.exists(dirPath)) {
                if (!(yield this.fileSystem.isDirectory(dirPath))) {
                    yield this.fileSystem.deleteFile(dirPath, true);
                    yield this.fileSystem.createDirectory(dirPath);
                }
            }
            else {
                yield this.fileSystem.createDirectory(dirPath);
            }
        });
    }
    getFilePath(fileName, fileNumber) {
        return __awaiter(this, void 0, void 0, function* () {
            const dirPath = yield this.getOfflineDirFilePath();
            return Object.assign(Object.assign({}, dirPath), { filePath: path_1.default.join(dirPath.filePath, this.fileNamePrefix + fileName + '.' + fileNumber) });
        });
    }
    getOfflineDirFilePath() {
        return __awaiter(this, void 0, void 0, function* () {
            const storageUnits = yield this.fileSystem.listStorageUnits();
            const internalStorageUnit = storageUnits.filter((storageUnit) => !storageUnit.removable)[0];
            return {
                filePath: OFFLINE_DIR,
                storageUnit: internalStorageUnit,
            };
        });
    }
    actionToFileEntry(action) {
        const sanitizedAction = lodash_1.default.omit(action, '__offline');
        return JSON.stringify(sanitizedAction) + '\n';
    }
    getUploadUri(baseUrl, deviceUid) {
        const UPLOAD_PATH = '/upload/file';
        const prefix = `offline-actions/${systemLogActions_1.SystemLog}/${deviceUid}/`;
        return `${baseUrl}${UPLOAD_PATH}?prefix=${prefix}`;
    }
    updateDeviceSpace() {
        return __awaiter(this, void 0, void 0, function* () {
            const localStorages = yield this.fileSystem.listStorageUnits();
            const internalStorage = localStorages.find((storage) => !storage.removable);
            if (internalStorage) {
                this.deviceFreeSpace = internalStorage === null || internalStorage === void 0 ? void 0 : internalStorage.freeSpace;
            }
        });
    }
    getFileNumber() {
        const dates = new Date();
        return dates.getFullYear() + dates.getMonth() + dates.getDay() + dates.getHours();
    }
    getFilePathUpload(fileName) {
        return __awaiter(this, void 0, void 0, function* () {
            const dirPath = yield this.getOfflineDirFilePath();
            let filePath;
            const directoryExists = yield this.fileSystem.exists(dirPath);
            if (!directoryExists) {
                filePath = Object.assign(Object.assign({}, dirPath), { filePath: path_1.default.join(dirPath.filePath, this.fileNamePrefix + fileName) });
            }
            else {
                const dirContent = yield this.fileSystem.listFiles(dirPath);
                switch (dirContent.length) {
                    case 0:
                        filePath = Object.assign(Object.assign({}, dirPath), { filePath: path_1.default.join(dirPath.filePath, this.fileNamePrefix + fileName) });
                        break;
                    case 1:
                        const rightFilePath = this.checkFilePath(dirContent[0].filePath);
                        filePath = Object.assign(Object.assign({}, dirPath), { filePath: rightFilePath });
                        break;
                    default:
                        let files = this.fileNamePrefix.includes(FRONT_FILE)
                            ? dirContent.filter((file) => file.filePath.includes(FRONT_FILE))
                            : dirContent.filter((file) => file.filePath.includes(MANAGEMENT_FILE));
                        const rightFilePathFiles = this.checkFilePath(files[0].filePath);
                        filePath = Object.assign(Object.assign({}, dirPath), { filePath: rightFilePathFiles });
                        break;
                }
            }
            return filePath;
        });
    }
    checkFilePath(filePath) {
        return !filePath.startsWith('.') ? '.' + filePath : filePath;
    }
    start() {
        const deviceFreeSpace = this.deviceFreeSpace;
        if (deviceFreeSpace === undefined) {
            this.storageInterval = setInterval(() => {
                this.updateDeviceSpace();
            }, REFRESH_SPACE_INTERVAL);
        }
    }
    stop() {
        if (this.storageInterval) {
            this.deviceFreeSpace = undefined;
            clearInterval(this.storageInterval);
        }
    }
}
exports.OfflineActionsUploader = OfflineActionsUploader;
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OfflineActionsUploader.prototype, "addAction", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", Promise)
], OfflineActionsUploader.prototype, "upload", null);
//# sourceMappingURL=OfflineActionsUploader.js.map