/**
 * An ISO 8061 time-zone offset is the amount of time that a time-zone differs from Greenwich/UTC.
 * This is usually a fixed number of hours and minutes.
 *
 * Negative UTC offsets describe a time zone west of UTC±00:00, where the civil time is behind (or earlier) than UTC
 * so the zone designator will look like "−03:00","−0300", or "−03".
 *
 * Positive UTC offsets describe a time zone at or east of UTC±00:00, where the civil time is the same as or
 * ahead (or later) than UTC so the zone designator will look like "+02:00","+0200", or "+02".
 *
 * In 2008, time-zone offsets around the world extended from -12:00 to +14:00.
 * To prevent any problems with that range being extended, yet still provide validation, the range of offsets
 * is restricted to -18:00 to 18:00 inclusive.
 */
export default class ZoneOffset {
    readonly totalMinutes: number;
    private static MIN_RANGE_TOTAL_MINUTES;
    private static MAX_RANGE_TOTAL_MINUTES;
    static fromTime(hours: number, minutes?: number): ZoneOffset;
    /**
     * A negative offset indicates a time zone east of the Prime Meridian. A positive offset indicates the time zone
     * west of the Prime Meridian.
     */
    static fromPosix(reverseMinutes: number): ZoneOffset;
    constructor(totalMinutes: number);
    /**
     * A negative offset indicates a time zone east of the Prime Meridian. A positive offset indicates the time zone
     * west of the Prime Meridian.
     */
    toPosix(): number;
    toString(): string;
}
