"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dateMonkeyPatch_1 = require("@signageos/lib/dist/DateTime/dateMonkeyPatch");
const momentTimezone = __importStar(require("moment-timezone"));
const Property_1 = __importDefault(require("../../Property/Property"));
const ZoneOffset_1 = __importDefault(require("./ZoneOffset"));
class EmulatorTimeManager {
    constructor(window) {
        this.window = window;
        this.originalDate = (0, dateMonkeyPatch_1.overrideDateCurrentTimestamp)(window, () => this.getOverridenTimestamp());
    }
    getEpochMillis() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.getOverridenTimestamp();
        });
    }
    getZoneOffset() {
        return __awaiter(this, void 0, void 0, function* () {
            const overridenTimezoneOffset = this.loadOverridenTimezoneOffset();
            const originalTimezoneOffset = new this.originalDate().getTimezoneOffset();
            return new ZoneOffset_1.default(overridenTimezoneOffset !== null && overridenTimezoneOffset !== void 0 ? overridenTimezoneOffset : originalTimezoneOffset);
        });
    }
    canGetZoneId() {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    getZoneId() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            return (_a = this.loadOverridenTimezone()) !== null && _a !== void 0 ? _a : Intl.DateTimeFormat().resolvedOptions().timeZone;
        });
    }
    canGetNtpServer() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    getNtpServer() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Device is unable to return NTP server');
        });
    }
    canSetManual() {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    setManual(epochMillis, zoneId) {
        return __awaiter(this, void 0, void 0, function* () {
            const timezoneOffset = momentTimezone.tz(epochMillis, zoneId).utcOffset();
            this.saveOverringTimezoneOffset(timezoneOffset);
            this.saveOverridenTimezone(zoneId);
            this.saveOverridenTimestampSettings({ timestamp: epochMillis, updatedAt: this.originalDate.now() });
        });
    }
    canSetAuto() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    setAuto() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('NTP server not supported');
        });
    }
    isAutoEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    getOverridenTimestamp() {
        const overridenTimestampSettings = this.loadOverridenTimestampSettings();
        if (overridenTimestampSettings) {
            return this.originalDate.now() - overridenTimestampSettings.updatedAt + overridenTimestampSettings.timestamp;
        }
        return this.originalDate.now();
    }
    loadOverridenTimestampSettings() {
        const overridenTimestamp = this.window.localStorage.getItem(EmulatorTimeManager.OVERRIDEN_TIMESTAMP_SETTINGS_KEY);
        if (overridenTimestamp) {
            return JSON.parse(overridenTimestamp);
        }
        return null;
    }
    saveOverridenTimestampSettings(settings) {
        this.window.localStorage.setItem(EmulatorTimeManager.OVERRIDEN_TIMESTAMP_SETTINGS_KEY, JSON.stringify(settings));
    }
    loadOverridenTimezoneOffset() {
        return Number(this.window.localStorage.getItem(EmulatorTimeManager.OVERRIDEN_TIMEZONE_OFFSET_KEY));
    }
    saveOverringTimezoneOffset(timezoneOffset) {
        this.window.localStorage.setItem(EmulatorTimeManager.OVERRIDEN_TIMEZONE_OFFSET_KEY, String(timezoneOffset));
    }
    loadOverridenTimezone() {
        return this.window.localStorage.getItem(EmulatorTimeManager.OVERRIDEN_TIMEZONE_KEY);
    }
    saveOverridenTimezone(timezone) {
        this.window.localStorage.setItem(EmulatorTimeManager.OVERRIDEN_TIMEZONE_KEY, timezone);
    }
}
EmulatorTimeManager.OVERRIDEN_TIMESTAMP_SETTINGS_KEY = 'default.native_device.OVERRIDEN_TIMESTAMP';
EmulatorTimeManager.OVERRIDEN_TIMEZONE_OFFSET_KEY = Property_1.default.CURRENT_TIMEZONE_OFFSET;
EmulatorTimeManager.OVERRIDEN_TIMEZONE_KEY = 'default.native_device.OVERRIDEN_TIMEZONE';
exports.default = EmulatorTimeManager;
//# sourceMappingURL=EmulatorTimeManager.js.map