import ITimeManager from './ITimeManager';
import ZoneOffset from './ZoneOffset';
export default class EmulatorTimeManager implements ITimeManager {
    private window;
    private static OVERRIDEN_TIMESTAMP_SETTINGS_KEY;
    private static OVERRIDEN_TIMEZONE_OFFSET_KEY;
    private static OVERRIDEN_TIMEZONE_KEY;
    private originalDate;
    constructor(window: Window);
    getEpochMillis(): Promise<number>;
    getZoneOffset(): Promise<ZoneOffset>;
    canGetZoneId(): Promise<boolean>;
    getZoneId(): Promise<string>;
    canGetNtpServer(): Promise<boolean>;
    getNtpServer(): Promise<string | null>;
    canSetManual(): Promise<boolean>;
    setManual(epochMillis: number, zoneId: string): Promise<void>;
    canSetAuto(): Promise<boolean>;
    setAuto(): Promise<void>;
    isAutoEnabled(): Promise<boolean>;
    private getOverridenTimestamp;
    private loadOverridenTimestampSettings;
    private saveOverridenTimestampSettings;
    private loadOverridenTimezoneOffset;
    private saveOverringTimezoneOffset;
    private loadOverridenTimezone;
    private saveOverridenTimezone;
}
