"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ZoneOffset_1 = __importDefault(require("./ZoneOffset"));
class BasicTimeManager {
    getEpochMillis() {
        return __awaiter(this, void 0, void 0, function* () {
            return Date.now();
        });
    }
    getZoneOffset() {
        return __awaiter(this, void 0, void 0, function* () {
            return ZoneOffset_1.default.fromPosix(new Date().getTimezoneOffset());
        });
    }
    canGetZoneId() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    getZoneId() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Device is unable to return timezone');
        });
    }
    canGetNtpServer() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    getNtpServer() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Device is unable to return NTP server');
        });
    }
    canSetManual() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    setManual() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Device is unable to set time manually');
        });
    }
    canSetAuto() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    setAuto() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Device is unable to set time automatically');
        });
    }
    isAutoEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
}
exports.default = BasicTimeManager;
//# sourceMappingURL=BasicTimeManager.js.map