"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVideoOrientation = exports.getOrientation = exports.setOrientation = void 0;
const Orientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/Orientation"));
const VideoOrientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/VideoOrientation"));
const ORIENTATION_KEY = 'local-config-ORIENTATION_KEY';
const VIDEO_ORIENTATION_KEY = 'local-config-VIDEO_ORIENTATION_KEY';
const ORIENTATION_PORTRAIT_VALUE = 'local-config-ORIENTATION_PORTRAIT_VALUE';
const ORIENTATION_LANDSCAPE_FLIPPED_VALUE = 'local-config-ORIENTATION_LANDSCAPE_FLIPPED_VALUE';
const ORIENTATION_PORTRAIT_FLIPPED_VALUE = 'local-config-ORIENTATION_PORTRAIT_FLIPPED_VALUE';
const VIDEO_ORIENTATION_LANDSCAPE_VALUE = 'local-config-VIDEO_ORIENTATION_LANDSCAPE_VALUE';
const VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE = 'local-config-VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE';
function setOrientation(storage, orientation, videoOrientation) {
    let contentOrientationValue = undefined;
    let videoOrientationValue = undefined;
    switch (orientation) {
        case Orientation_1.default.PORTRAIT:
            contentOrientationValue = ORIENTATION_PORTRAIT_VALUE;
            break;
        case Orientation_1.default.LANDSCAPE:
            break;
        case Orientation_1.default.PORTRAIT_FLIPPED:
            contentOrientationValue = ORIENTATION_PORTRAIT_FLIPPED_VALUE;
            break;
        case Orientation_1.default.LANDSCAPE_FLIPPED:
            contentOrientationValue = ORIENTATION_LANDSCAPE_FLIPPED_VALUE;
            break;
        default:
            throw new Error('Invalid orientation');
    }
    switch (videoOrientation) {
        case VideoOrientation_1.default.LANDSCAPE:
            videoOrientationValue = VIDEO_ORIENTATION_LANDSCAPE_VALUE;
            break;
        case VideoOrientation_1.default.LANDSCAPE_FLIPPED:
            videoOrientationValue = VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE;
            break;
        default:
    }
    if (contentOrientationValue) {
        storage.setItem(ORIENTATION_KEY, contentOrientationValue);
    }
    else {
        storage.removeItem(ORIENTATION_KEY);
    }
    if (videoOrientationValue) {
        storage.setItem(VIDEO_ORIENTATION_KEY, videoOrientationValue);
    }
    else {
        storage.removeItem(VIDEO_ORIENTATION_KEY);
    }
}
exports.setOrientation = setOrientation;
function getOrientation(storage) {
    const orientation = storage.getItem(ORIENTATION_KEY);
    switch (orientation) {
        case ORIENTATION_PORTRAIT_VALUE:
            return Orientation_1.default.PORTRAIT;
        case ORIENTATION_PORTRAIT_FLIPPED_VALUE:
            return Orientation_1.default.PORTRAIT_FLIPPED;
        case ORIENTATION_LANDSCAPE_FLIPPED_VALUE:
            return Orientation_1.default.LANDSCAPE_FLIPPED;
        default:
            return Orientation_1.default.LANDSCAPE;
    }
}
exports.getOrientation = getOrientation;
function getVideoOrientation(storage) {
    const orientation = storage.getItem(VIDEO_ORIENTATION_KEY);
    switch (orientation) {
        case VIDEO_ORIENTATION_LANDSCAPE_VALUE:
            return VideoOrientation_1.default.LANDSCAPE;
        case VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE:
            return VideoOrientation_1.default.LANDSCAPE_FLIPPED;
        default:
            return null;
    }
}
exports.getVideoOrientation = getVideoOrientation;
//# sourceMappingURL=screenRotationStorageHelper.js.map