"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Orientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/Orientation"));
class ScreenRotationViewportPropsProvider {
    /**
     * @param rotateClockwise On most platforms, counter-clockwise should be the correct option
     */
    constructor(rotateClockwise) {
        this.rotateClockwise = rotateClockwise;
    }
    getProps(orientation) {
        if (this.rotateClockwise) {
            return this.getClockwiseProps(orientation);
        }
        else {
            return this.getCounterClockwiseProps(orientation);
        }
    }
    getClockwiseProps(orientation) {
        switch (orientation) {
            case Orientation_1.default.PORTRAIT:
                return this.getCounterClockwiseProps(Orientation_1.default.PORTRAIT_FLIPPED);
            case Orientation_1.default.PORTRAIT_FLIPPED:
                return this.getCounterClockwiseProps(Orientation_1.default.PORTRAIT);
            default:
                return this.getCounterClockwiseProps(orientation);
        }
    }
    getCounterClockwiseProps(orientation) {
        const angles = {
            [Orientation_1.default.LANDSCAPE]: {
                angle: 0,
                translateX: '0%',
                translateY: '0%',
                width: '100vw',
                height: '100vh',
            },
            [Orientation_1.default.PORTRAIT_FLIPPED]: {
                angle: 90,
                translateX: '0%',
                translateY: '-100vw',
                width: '100vh',
                height: '100vw',
            },
            [Orientation_1.default.LANDSCAPE_FLIPPED]: {
                angle: 180,
                translateX: '-100vw',
                translateY: '-100vh',
                width: '100vw',
                height: '100vh',
            },
            [Orientation_1.default.PORTRAIT]: {
                angle: 270,
                translateX: '-100vh',
                translateY: '0%',
                width: '100vh',
                height: '100vw',
            },
        };
        return angles[orientation];
    }
}
exports.default = ScreenRotationViewportPropsProvider;
//# sourceMappingURL=ScreenRotationViewportPropsProvider.js.map