import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import IScreenRotationPropsProvider, { IScreenRotationProps } from './IScreenRotationPropsProvider';
export default class ScreenRotationPixelPropsProvider implements IScreenRotationPropsProvider {
    private rotateClockwise;
    private resContainer;
    /**
     * @param rotateClockwise On most platforms, counter-clockwise should be the correct option
     * @param resContains Usually a simple window, but with limited access to inner resolutions only
     */
    constructor(rotateClockwise: boolean, resContainer: Pick<Window, 'innerWidth' | 'innerHeight'>);
    getProps(orientation: Orientation): IScreenRotationProps;
    private getClockwiseProps;
    private getCounterClockwiseProps;
}
