"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const CSSRotationVideoPlayerAdapter_1 = __importDefault(require("./CSSRotationVideoPlayerAdapter"));
const CSSRotationStreamPlayerAdapter_1 = __importDefault(require("./CSSRotationStreamPlayerAdapter"));
class ScreenRotationManager {
    constructor(window, propsProvider, elements, getOrientation) {
        this.window = window;
        this.propsProvider = propsProvider;
        this.elements = elements;
        this.getOrientation = getOrientation;
    }
    applyOrientation() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.applyOrientationToElements(this.elements);
        });
    }
    adaptVideoPlayer(videoPlayer) {
        return new CSSRotationVideoPlayerAdapter_1.default(this.window, videoPlayer, () => __awaiter(this, void 0, void 0, function* () {
            const orientation = yield this.getOrientation();
            const rotationProps = this.propsProvider.getProps(orientation);
            return rotationProps.angle;
        }));
    }
    adaptStreamPlayer(streamPlayer) {
        return new CSSRotationStreamPlayerAdapter_1.default(this.window, streamPlayer, () => __awaiter(this, void 0, void 0, function* () {
            const orientation = yield this.getOrientation();
            const rotationProps = this.propsProvider.getProps(orientation);
            return rotationProps.angle;
        }));
    }
    adaptHTMLElementProducer(htmlElementProducer) {
        htmlElementProducer.onElementCreated((element) => __awaiter(this, void 0, void 0, function* () {
            yield this.applyOrientationToElements([element]);
        }));
        return htmlElementProducer;
    }
    applyOrientationToElements(elements) {
        return __awaiter(this, void 0, void 0, function* () {
            const orientation = yield this.getOrientation();
            const rotationProps = this.propsProvider.getProps(orientation);
            for (const element of elements) {
                element.style.width = rotationProps.width;
                element.style.height = rotationProps.height;
                element.style.transform = element.style.webkitTransform =
                    `rotate(${rotationProps.angle}deg) ` +
                        `translateX(${rotationProps.translateX}) ` +
                        `translateY(${rotationProps.translateY}) ` +
                        `translateZ(0)`;
                element.style.transformOrigin = element.style.webkitTransformOrigin = `top left`;
            }
        });
    }
}
exports.default = ScreenRotationManager;
//# sourceMappingURL=ScreenRotationManager.js.map