import IVideoPlayer, { IPrepareOptions } from '../../Video/IVideoPlayer';
import IVideoEventEmitter from '../../Video/IVideoEventEmitter';
/**
 * Wrapper class for any implementation of video player that converts CSS-rotated coordinates back to landscape for the system
 *
 * When the content is rotated via CSS, all the coordinates that are sent from it are rotated as well.
 * That's bad because from the point of view of the system it's landscape and the rotated coordinates don't make sense.
 * This is a proxy class that converts the coordinates between the client and the system so neither of them have to worry about it.
 */
export default class CSSRotationVideoPlayerAdapter implements IVideoPlayer {
    private window;
    private videoPlayer;
    private getAngle;
    constructor(window: Window, videoPlayer: IVideoPlayer, getAngle: () => Promise<number>);
    getMaxVideoCount(): number | null;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IPrepareOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number): Promise<IVideoEventEmitter>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    getDuration(uri: string, x: number, y: number, width: number, height: number): Promise<number>;
    private convertEventEmitterWithConvertedCoordinatesBackToOriginalCoordinates;
}
