"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPowerActionTimerPropertyStorage = void 0;
const Property_1 = __importDefault(require("../../Property/Property"));
const MigratingPowerActionTimerPropertyStorage_1 = __importDefault(require("./MigratingPowerActionTimerPropertyStorage"));
const PowerActionTimerPropertyStorage_1 = __importDefault(require("./PowerActionTimerPropertyStorage"));
function createPowerActionTimerPropertyStorage(propertyStorage, property) {
    const oldStorage = () => new PowerActionTimerPropertyStorage_1.default(propertyStorage, Property_1.default.POWER_ACTIONS_SCHEDULE_SETTINGS);
    const newStorage = new PowerActionTimerPropertyStorage_1.default(propertyStorage, property);
    return new MigratingPowerActionTimerPropertyStorage_1.default(oldStorage, newStorage);
}
exports.createPowerActionTimerPropertyStorage = createPowerActionTimerPropertyStorage;
//# sourceMappingURL=powerActionTimerStorages.js.map