"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const Weekday_1 = __importDefault(require("@signageos/actions/dist/Misc/Weekday"));
class PowerActionTimerPropertyStorage {
    constructor(propertyStorage, property) {
        this.propertyStorage = propertyStorage;
        this.property = property;
    }
    content() {
        return __awaiter(this, void 0, void 0, function* () {
            const currentSettings = yield this.loadSettings();
            return Object.keys(currentSettings).reduce((result, uid) => (Object.assign(Object.assign({}, result), { [uid]: {
                    powerType: PowerActionType_1.default[currentSettings[uid].powerType],
                    weekdays: currentSettings[uid].weekdays.map((weekday) => Weekday_1.default[weekday]),
                    time: currentSettings[uid].time,
                } })), {});
        });
    }
    put(uid, rule) {
        return __awaiter(this, void 0, void 0, function* () {
            const { powerType, weekdays, time } = rule;
            const currentSettings = yield this.loadSettings();
            if (currentSettings[uid]) {
                console.warn('Scheduled power action with uid already exists: ' + uid);
            }
            yield this.saveSettings(Object.assign(Object.assign({}, currentSettings), { [uid]: {
                    powerType: PowerActionType_1.default[powerType],
                    weekdays: weekdays.map((weekday) => Weekday_1.default[weekday]),
                    time,
                } }));
        });
    }
    remove(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            const currentSettings = yield this.loadSettings();
            if (!currentSettings[uid]) {
                return false;
            }
            delete currentSettings[uid];
            yield this.saveSettings(currentSettings);
            return true;
        });
    }
    clear() {
        return __awaiter(this, void 0, void 0, function* () {
            const currentSettings = yield this.loadSettings();
            if (Object.keys(currentSettings).length === 0) {
                return false;
            }
            yield this.saveSettings({});
            return true;
        });
    }
    putAll(rules) {
        return __awaiter(this, void 0, void 0, function* () {
            const currentSettings = yield this.loadSettings();
            const storedRules = Object.keys(rules).reduce((result, uid) => (Object.assign(Object.assign({}, result), { [uid]: {
                    powerType: PowerActionType_1.default[rules[uid].powerType],
                    weekdays: rules[uid].weekdays.map((weekday) => Weekday_1.default[weekday]),
                    time: rules[uid].time,
                } })), {});
            yield this.saveSettings(Object.assign(Object.assign({}, currentSettings), storedRules));
            return true;
        });
    }
    /**
     * @returns Whether this storage has ever persisted any data.
     */
    hasPersistedData() {
        return __awaiter(this, void 0, void 0, function* () {
            const currentSettings = yield this.propertyStorage.getValueOrDefault(this.property, undefined);
            return typeof currentSettings !== 'undefined';
        });
    }
    loadSettings() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.propertyStorage.getValueOrDefault(this.property, {});
        });
    }
    saveSettings(rules) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.propertyStorage.setValue(this.property, rules);
        });
    }
}
exports.default = PowerActionTimerPropertyStorage;
//# sourceMappingURL=PowerActionTimerPropertyStorage.js.map