import Property from '../../Property/Property';
import { IPropertyStorage } from '../../Property/propertyStorage';
import IPowerActionTimerStorage from './IPowerActionTimerStorage';
import { PowerActionRule, PowerActionRules } from './IPowerActionTimer';
export type PowerActionRulesProperty = Property.POWER_ACTIONS_SCHEDULE_SETTINGS_FRONT | Property.POWER_ACTIONS_SCHEDULE_SETTINGS_MANAGEMENT;
type PrivatePowerActionRulesProperty = PowerActionRulesProperty | Property.POWER_ACTIONS_SCHEDULE_SETTINGS;
export default class PowerActionTimerPropertyStorage implements IPowerActionTimerStorage {
    private readonly propertyStorage;
    private readonly property;
    constructor(propertyStorage: IPropertyStorage, property: PrivatePowerActionRulesProperty);
    content(): Promise<PowerActionRules>;
    put(uid: string, rule: PowerActionRule): Promise<void>;
    remove(uid: string): Promise<boolean>;
    clear(): Promise<boolean>;
    putAll(rules: PowerActionRules): Promise<boolean>;
    /**
     * @returns Whether this storage has ever persisted any data.
     */
    hasPersistedData(): Promise<boolean>;
    private loadSettings;
    private saveSettings;
}
export {};
