import IPowerActionTimer, { PowerActionRule, PowerActionRules } from './IPowerActionTimer';
/**
 * A Power Action Timer that doesn't support persisting rules
 * and scheduling power actions (will throw error).
 */
export default class NotImplementedPowerActionTimer implements IPowerActionTimer {
    /**
     * @throws Unsupported operation
     */
    set(_uid: string, _rule: PowerActionRule): Promise<void>;
    /**
     * @throws Unsupported operation
     */
    unset(..._uid: string[]): Promise<void>;
    /**
     * @throws Unsupported operation
     */
    reset(): Promise<void>;
    /**
     * @returns An empty set of rules
     */
    rules(): Promise<PowerActionRules>;
    /**
     * Does nothing.
     */
    notifyStart(): Promise<void>;
    /**
     * Does nothing.
     */
    notifyEnd(): Promise<void>;
}
