"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Power Action Timer storage that copies rules from ``oldStorage`` to ``newStorage``
 * if ``newStorage`` hasn't been written to yet.
 *
 * Migration is ensured to run at most once before any method returns.
 */
class MigratingPowerActionTimerPropertyStorage {
    constructor(oldStorage, newStorage) {
        this.oldStorage = oldStorage;
        this.newStorage = newStorage;
        /**
         * We want the migration done before any accessor runs and *only once*.
         * We don't care if it's lazy or eager.
         */
        this.migration = this.performMigration(); // TODO: this is possibly uncaught exception
    }
    put(uid, rule) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.migration;
            return yield this.newStorage.put(uid, rule);
        });
    }
    remove(uid) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.migration;
            return yield this.newStorage.remove(uid);
        });
    }
    clear() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.migration;
            return yield this.newStorage.clear();
        });
    }
    content() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.migration;
            return yield this.newStorage.content();
        });
    }
    performMigration() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!(yield this.newStorage.hasPersistedData())) {
                yield this.newStorage.putAll(yield this.oldStorage().content());
                console.debug('Power Action Timer storage migration complete.');
            }
        });
    }
}
exports.default = MigratingPowerActionTimerPropertyStorage;
//# sourceMappingURL=MigratingPowerActionTimerPropertyStorage.js.map