import PowerActionType from '@signageos/actions/dist/Device/Power/PowerActionType';
import { PowerActionRules } from './IPowerActionTimer';
/**
 * Instances are responsible for
 * * building a schedule from supplied Power Action Timer rules
 * * and firing events at appropriate times.
 *
 * Instances are *not* responsible for
 * * executing Power Actions.
 */
export default interface IPowerActionScheduler {
    reschedule(rules: PowerActionRules): void;
    unschedule(): void;
    addListener(listener: PowerActionListener): void;
    removeListener(listener: PowerActionListener): void;
}
export type PowerActionEvent = PowerActionType;
export type PowerActionListener = (event: PowerActionEvent) => void;
