"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class DefaultPowerActionTimer {
    constructor(storage, scheduler, executor) {
        this.storage = storage;
        this.scheduler = scheduler;
        this.executor = executor;
        this.started = false;
        this.listener = (event) => {
            this.executor.execute(event);
        };
    }
    set(uid, rule) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.storage.put(uid, rule);
            if (this.started) {
                this.scheduler.reschedule(yield this.rules());
            }
        });
    }
    unset(...uid) {
        return __awaiter(this, void 0, void 0, function* () {
            let changed = false;
            yield Promise.all(uid.map((u) => __awaiter(this, void 0, void 0, function* () {
                changed = changed || (yield this.storage.remove(u));
            })));
            if (this.started && changed) {
                this.scheduler.reschedule(yield this.rules());
            }
        });
    }
    reset() {
        return __awaiter(this, void 0, void 0, function* () {
            const changed = yield this.storage.clear();
            if (this.started && changed) {
                this.scheduler.reschedule(yield this.rules());
            }
        });
    }
    rules() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.storage.content();
        });
    }
    notifyStart() {
        return __awaiter(this, void 0, void 0, function* () {
            this.started = true;
            this.scheduler.addListener(this.listener);
            this.scheduler.reschedule(yield this.rules());
        });
    }
    notifyEnd() {
        return __awaiter(this, void 0, void 0, function* () {
            this.started = false;
            this.scheduler.removeListener(this.listener);
            this.scheduler.unschedule();
        });
    }
}
exports.default = DefaultPowerActionTimer;
//# sourceMappingURL=DefaultPowerActionTimer.js.map