export type MdcIpAddressType = 'localhost' | string;
export type MdcType = 'ACK' | 'NACK';
/**
 * Send One Response returned from Tizen MDC
 */
export interface IMdcSendOneResponse {
    type: MdcType;
    commandType: number;
    result: number | string;
}
/**
 * Tizen MDC Command Interface
 */
export interface IMdc {
    /**
     * Send one MDC command on selected IP Address or localhost
     * @param ipAddress IP Address of the device or `localhost`
     * @param command MDC command as number
     * @param data Data array
     */
    sendOne(ipAddress: MdcIpAddressType, command: number, data: number[] | []): Promise<IMdcSendOneResponse>;
    /**
     * Send one MDC command on selected IP Address or localhost data as raw
     * @param ipAddress IP Address of the device or `localhost`
     * @param data MDC data array
     */
    sendOneRaw(ipAddress: MdcIpAddressType, data: number[]): Promise<IMdcSendOneResponse>;
}
