import IWifi, { IWifiDevice, WifiEvent, IWifiConnectOptions } from './IWifi';
export default class NotImplementedWifi implements IWifi {
    isClientEnabled(): Promise<boolean>;
    enableClient(): Promise<void>;
    isAPEnabled(): Promise<boolean>;
    enableAP(_ssid: string, _passphrase: string): Promise<void>;
    disable(): Promise<void>;
    connect(_ssid: string, _password?: string, _options?: IWifiConnectOptions): Promise<void>;
    disconnect(): Promise<void>;
    getConnectedTo(): Promise<IWifiDevice | null>;
    getCountry(): Promise<string | null>;
    setCountry(_countryCode: string): Promise<void>;
    scan(): Promise<IWifiDevice[]>;
    on(_event: WifiEvent, _listener: (...args: any[]) => void): void;
    once(_event: WifiEvent, _listener: (...args: any[]) => void): void;
    removeListener(_event: WifiEvent, _listener: (...args: any[]) => void): void;
    removeAllListeners(_event?: WifiEvent): void;
}
