"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEmulatorUid = void 0;
const js_cookie_1 = __importDefault(require("js-cookie"));
const url_1 = __importDefault(require("url"));
const getEmulatorUid = (href) => {
    var _a;
    const currentLocation = url_1.default.parse(href, true);
    if ((_a = currentLocation.query) === null || _a === void 0 ? void 0 : _a.duid) {
        return [currentLocation.query.duid].flat()[0];
    }
    else if (!js_cookie_1.default.get('DUID')) {
        const fakeDuid = '' + Math.random();
        js_cookie_1.default.set('DUID', fakeDuid, {
            expires: 10 * 365,
        });
        return fakeDuid;
    }
    else {
        return js_cookie_1.default.get('DUID');
    }
};
exports.getEmulatorUid = getEmulatorUid;
//# sourceMappingURL=getEmulatorUid.js.map