"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const screenRotationStorageHelper_1 = require("../Screen/screenRotationStorageHelper");
class DefaultSettingsManager {
    constructor(window) {
        this.window = window;
        this.eventEmitter = new events_1.EventEmitter();
    }
    getVolume() {
        const volumeValue = this.window.localStorage.getItem(DefaultSettingsManager.VOLUME_KEY);
        return volumeValue !== null ? parseInt(volumeValue) : 100;
    }
    setVolume(volume) {
        this.window.localStorage.setItem(DefaultSettingsManager.VOLUME_KEY, volume.toString());
        this.eventEmitter.emit('volume_change', volume);
    }
    onVolumeChange(listener) {
        this.eventEmitter.addListener('volume_change', listener);
    }
    getOrientation() {
        return (0, screenRotationStorageHelper_1.getOrientation)(this.window.localStorage);
    }
    getVideoOrientation() {
        return (0, screenRotationStorageHelper_1.getVideoOrientation)(this.window.localStorage);
    }
    setOrientation(orientation, videoOrientation) {
        return (0, screenRotationStorageHelper_1.setOrientation)(this.window.localStorage, orientation, videoOrientation);
    }
    setResolution(resolution) {
        this.window.localStorage.setItem(DefaultSettingsManager.RESOLUTION_KEY, JSON.stringify(resolution));
    }
    getResolution() {
        const resolutionItemRaw = this.window.localStorage.getItem(DefaultSettingsManager.RESOLUTION_KEY);
        if (resolutionItemRaw) {
            try {
                return JSON.parse(resolutionItemRaw);
            }
            catch (error) {
                console.error('Failed to parse resolution', error);
            }
        }
        const resolutionItem = {
            width: Math.round(this.window.innerWidth * this.window.devicePixelRatio),
            height: Math.round(this.window.innerHeight * this.window.devicePixelRatio),
        };
        return resolutionItem;
    }
}
DefaultSettingsManager.VOLUME_KEY = 'default.native_device.VOLUME';
DefaultSettingsManager.RESOLUTION_KEY = 'default.native_device.RESOLUTION_KEY';
exports.default = DefaultSettingsManager;
//# sourceMappingURL=DefaultSettingsManager.js.map