"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultFrontDriver = void 0;
const debug_1 = __importDefault(require("debug"));
const FileSystemWithReservedSpace_1 = require("../../FileSystem/FileSystemWithReservedSpace");
const fileSystemHelper_1 = require("../../FileSystem/fileSystemHelper");
const security_1 = require("../../Front/Security/security");
const propertyStorage_1 = __importDefault(require("../../Property/propertyStorage"));
const overlayHelper_1 = require("../../Screen/overlayHelper");
const asyncStorageHelper_1 = require("../../Storage/Async/asyncStorageHelper");
const ProprietaryTimerPropertyStorage_1 = __importDefault(require("../../Timer/ProprietaryTimerPropertyStorage"));
const FrontCapability_1 = __importDefault(require("../Front/FrontCapability"));
const NotImplementedSerial_1 = __importDefault(require("../Hardware/NotImplementedSerial"));
const KeyCode_1 = require("../Input/KeyCode");
const debug = (0, debug_1.default)('@signageos/front-display:NativeDevice:Default:DefaultFrontDriver');
class DefaultFrontDriver {
    static support(_window) {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    constructor(window, video, stream, browser, basicDriver, cacheDriver, storage, realFileSystem) {
        this.window = window;
        this.video = video;
        this.stream = stream;
        this.browser = browser;
        this.basicDriver = basicDriver;
        this.storage = storage;
        this.realFileSystem = realFileSystem;
        this.hardware = {
            led: {
                setColor(_color) {
                    return __awaiter(this, void 0, void 0, function* () {
                        console.info(new Error('Not implemented hardware led set color'));
                    });
                },
            },
            serial: new NotImplementedSerial_1.default(),
            barcodeScanner: {
                getVersion() {
                    return __awaiter(this, void 0, void 0, function* () {
                        throw new Error('Not implemented barcode scanner');
                    });
                },
                startScanning() {
                    return __awaiter(this, void 0, void 0, function* () {
                        throw new Error('Not implemented barcode scanner');
                    });
                },
                stopScanning() {
                    return __awaiter(this, void 0, void 0, function* () {
                        throw new Error('Not implemented barcode scanner');
                    });
                },
            },
        };
        this.asyncStorage = (0, asyncStorageHelper_1.asynchronizeStorage)(this.storage);
        this.fileSystem = (0, FileSystemWithReservedSpace_1.createFileSystemWithReservedSpaceWithWindowHttpHeadFetcher)(this.realFileSystem, this.window, fileSystemHelper_1.RESERVED_SPACE_PERCENTAGE);
        this.security = (0, security_1.createCompatibleSecurity)(() => this, () => cacheDriver);
        this.proprietaryTimerStorage = new ProprietaryTimerPropertyStorage_1.default((0, propertyStorage_1.default)(() => cacheDriver));
    }
    getConfigurationBaseUrl() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.getConfigurationBaseUrl();
        });
    }
    getApplicationType() {
        return this.basicDriver.getApplicationType();
    }
    frontSupports(capability) {
        return __awaiter(this, void 0, void 0, function* () {
            switch (capability) {
                case FrontCapability_1.default.FILE_SYSTEM_INTERNAL_STORAGE:
                case FrontCapability_1.default.FILE_SYSTEM_FILE_CHECKSUM:
                case FrontCapability_1.default.TIMERS_PROPRIETARY:
                case FrontCapability_1.default.VIDEO_4K:
                case FrontCapability_1.default.FRONT_OSD:
                    return true;
                case FrontCapability_1.default.BROWSER:
                    return this.browser.isSupported();
                default:
                    return false;
            }
        });
    }
    initialize(_staticBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            yield (0, overlayHelper_1.updateOverlay)(this.window, this.asyncStorage);
            this.updateBrightness();
            yield this.realFileSystem.initialize();
        });
    }
    isDetected() {
        return false;
    }
    start() {
        this.basicDriver.start();
    }
    stop() {
        this.basicDriver.stop();
    }
    bindKeyUp(keyUpListener) {
        this.window.addEventListener('keyup', (event) => {
            var _a;
            const keyCode = (_a = KeyCode_1.keyboardKeyMap[event.key]) !== null && _a !== void 0 ? _a : KeyCode_1.keyboardKeyMap[event.key.toLocaleLowerCase()];
            if (keyCode !== undefined) {
                keyUpListener({ keyCode });
            }
            else {
                debug(new Error('Not supported keyCode ' + event.key));
            }
        });
    }
    getDeviceUid() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.getDeviceUid();
        });
    }
    isConnected() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.isConnected();
        });
    }
    getSessionId(sessionIdKey) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.getSessionId(sessionIdKey);
        });
    }
    setSessionId(sessionIdKey, sessionId) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.basicDriver.setSessionId(sessionIdKey, sessionId);
        });
    }
    remoteControlSetEnabled(_enabled) {
        console.info('Not implemented set on/off remote control');
        return Promise.resolve();
    }
    restoreDisplayArea() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.clearAll();
            yield this.stream.clearAll();
            yield this.browser.close();
        });
    }
    remoteControlIsEnabled() {
        console.info('Not implemented get on/off remote control');
        return Promise.resolve(true);
    }
    controlSetPin(_pin) {
        return __awaiter(this, void 0, void 0, function* () {
            console.warn(new Error('Not implemented set control pin'));
        });
    }
    browserOpenLink(uri) {
        return __awaiter(this, void 0, void 0, function* () {
            this.window.open(uri, '_blank', 'location=yes,height=640,width=480,scrollbars=yes,status=yes');
        });
    }
    getCurrentSignature() {
        return __awaiter(this, void 0, void 0, function* () {
            return null;
        });
    }
    getOSDUri() {
        return 'osd/index.html';
    }
    forwardTouchEvents(_callback) {
        return __awaiter(this, void 0, void 0, function* () {
            return undefined;
        });
    }
    updateBrightness() {
        const brightness = this.window.localStorage.getItem(DefaultFrontDriver.BRIGHTNESS_KEY);
        if (brightness !== null) {
            const newFilter = `brightness(${50 + parseInt(brightness) / 2}%)`;
            this.window.document.body.style.filter = newFilter;
            this.window.document.body.style.webkitFilter = newFilter;
        }
    }
}
exports.DefaultFrontDriver = DefaultFrontDriver;
DefaultFrontDriver.BRIGHTNESS_KEY = 'default.native_device.BRIGHTNESS';
//# sourceMappingURL=DefaultFrontDriver.js.map