"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ProprietaryCache_1 = __importDefault(require("../../Cache/ProprietaryCache"));
class DefaultCacheDriver {
    constructor(storage) {
        const DEFAULT_TOTAL_SIZE_BYTES = 5 * 1024 * 1024; // Default quota of localStorage in browsers
        this.cache = new ProprietaryCache_1.default(storage, DEFAULT_TOTAL_SIZE_BYTES);
    }
    cacheGetUids() {
        return this.cache.fetchAllUids();
    }
    cacheGetAll() {
        return this.cache.fetchAll();
    }
    cacheGet(uid) {
        return this.cache.fetchOne(uid);
    }
    cacheDelete(uid) {
        return this.cache.deleteOne(uid);
    }
    cacheSave(uid, content) {
        return this.cache.saveOne(uid, content);
    }
    cacheGetStorageInfo() {
        return this.cache.getStorageInfo();
    }
}
exports.default = DefaultCacheDriver;
//# sourceMappingURL=DefaultCacheDriver.js.map