import IConfig from '../Display/IConfig';
import { IResponsibilities } from '../Feature/Responsibilities';
import { IBundledApplet } from '../Front/Applet/BundledApplet/bundledAppletActions';
import { IPropertyStorage } from '../Property/propertyStorage';
import * as TestFramework from '../Test/TestFramework';
import IBundledServlet from './Servlet/IBundledServlet';
import { IManagementState } from './managementReducers';
import { ManagementCacheDriver } from '../NativeDevice/Default/combinedDriver';
export interface IManagementSagaOptions {
    nativeDriver: ManagementCacheDriver;
    publicKey: string;
    sessionIdKey: string;
    frontDisplayVersion: string;
    autoVerification: {
        organizationUid: string;
        deviceName?: string;
    } | undefined;
    applicationVersion: string;
    bundledApplet: IBundledApplet | null;
    bundledServlet: IBundledServlet | null;
    responsibilities: IResponsibilities;
    /** Additional tests that should run, apart from the standard suite that always runs */
    managementExtraTests?: Promise<TestFramework.Describe>[];
    logOfflineActions?: boolean;
    pingUrl: string;
}
export declare function managementSaga(defaultConfig: IConfig, { nativeDriver, publicKey, sessionIdKey, frontDisplayVersion, autoVerification, applicationVersion, bundledApplet, bundledServlet, responsibilities, managementExtraTests, logOfflineActions, pingUrl, }: IManagementSagaOptions, getState: () => IManagementState, propertyStorage: IPropertyStorage): Generator<import("redux-saga/effects").AllEffect<Iterator<any, any, undefined> | Generator<Promise<string> | import("redux-saga/effects").ForkEffect<any> | import("redux-saga").SagaIterator, void, {
    offlineActionsLimits: any;
} & string> | Generator<Promise<({
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
} | {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
} | {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
} | {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
})[]> | import("redux-saga/effects").CallEffect<void> | import("redux-saga/effects").PutEffect<import("../Front/Network/networkActions").NetworkStatusChanged>, void, ({
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
} | {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
} | {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
} | {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
})[]> | Generator<Promise<boolean> | import("redux-saga/effects").ForkEffect<Generator<import("redux-saga/effects").TakeEffect | Generator<import("redux-saga/effects").PutEffect<import("../Socket/socketActions").BindAction>, void, unknown> | Generator<import("redux-saga/effects").PutEffect<import("../Socket/socketActions").UnbindAction>, void, unknown>, never, unknown>> | Generator<Promise<void> | Promise<boolean> | import("redux-saga/effects").ForkEffect<never> | import("redux-saga/effects").TakeEffect, void, unknown>, void, boolean> | Generator<Promise<boolean> | import("redux-saga/effects").ForkEffect<Generator<import("@signageos/lib/dist/Promise/cancelable").CancelablePromise<void> | Generator<import("redux-saga/effects").CallEffect<void> | Promise<import("../NativeDevice/IBrightness").default | null>, void, import("../NativeDevice/IBrightness").default>, never, unknown>>, void, boolean> | Generator<Promise<boolean> | import("redux-saga/effects").ForkEffect<Generator<import("redux-saga/effects").TakeEffect | Generator<import("redux-saga/effects").PutEffect<import("../Socket/socketActions").BindAction>, void, unknown> | Generator<import("redux-saga/effects").PutEffect<import("../Socket/socketActions").UnbindAction>, void, unknown>, never, unknown>>, void, string>>, void, unknown>;
