"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileSystemWipeoutAction = void 0;
/** It clears the browser cookies, clears the persistent file system, and reboots the device */
function fileSystemWipeoutAction(managementDriver, cacheDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield clearCookies(window);
            yield clearCache(cacheDriver);
            yield managementDriver.fileSystem.wipeout();
        }
        catch (error) {
            console.warn('fileSystemWipeoutAction failed', error);
        }
    });
}
exports.fileSystemWipeoutAction = fileSystemWipeoutAction;
/** It deletes all cookies by setting their expiration date to the past */
function clearCookies(window) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let cookies = window.document.cookie.split('; ');
            for (let id = 0; id < cookies.length; id++) {
                let domain = window.location.hostname.split('.');
                while (domain.length > 0) {
                    let cookieBase = encodeURIComponent(cookies[id].split(';')[0].split('=')[0]) +
                        '=; expires=Thu, 01-Jan-1970 00:00:01 GMT; domain=' +
                        domain.join('.') +
                        ' ;path=';
                    let path = location.pathname.split('/');
                    document.cookie = cookieBase + '/';
                    while (path.length > 0) {
                        document.cookie = cookieBase + path.join('/');
                        path.pop();
                    }
                    domain.shift();
                }
            }
        }
        catch (error) {
            console.error('managementHelper - clearCookies failed', error);
        }
    });
}
/**
 * "Clear the cache by deleting all the keys in the cache."
 * @param nativeDriver - ICacheDriver
 */
function clearCache(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const uids = yield nativeDriver.cacheGetUids();
            yield Promise.allSettled(uids.map((uid) => __awaiter(this, void 0, void 0, function* () {
                yield nativeDriver.cacheDelete(uid);
            })));
        }
        catch (error) {
            console.error('managementHelper - clearCache failed', error);
        }
    });
}
//# sourceMappingURL=managementHelper.js.map