"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const lodash_1 = require("lodash");
const applicationFactory_1 = require("../Application/applicationFactory");
const Responsibilities_1 = require("../Feature/Responsibilities");
const Responsibility_1 = __importDefault(require("../Feature/Responsibility"));
const fetch_1 = require("../Isomorphic/fetch");
const combinedDriver_1 = require("../NativeDevice/Default/combinedDriver");
const propertyStorage_1 = __importDefault(require("../Property/propertyStorage"));
const managementReducers_1 = require("./managementReducers");
const managementSagas_1 = require("./managementSagas");
function startBackupRestartChecking(managementDriver, defaultBaseUrl) {
    const BACKUP_RESTART_STATUS_CODE = 299;
    setInterval(() => __awaiter(this, void 0, void 0, function* () {
        const type = PowerActionType_1.default[PowerActionType_1.default.BACKUP_RESTART];
        const deviceUid = yield managementDriver.getDeviceUid();
        const powerActionUri = defaultBaseUrl + '/power-action/' + type + '/' + deviceUid;
        const response = yield (0, fetch_1.fetch)(powerActionUri);
        if (response.status === BACKUP_RESTART_STATUS_CODE) {
            yield (0, fetch_1.fetch)(powerActionUri, { method: 'POST' });
            yield managementDriver.systemReboot();
        }
    }), 200e3);
}
exports.default = (options) => __awaiter(void 0, void 0, void 0, function* () {
    const { managementDriver, cacheDriver } = (0, combinedDriver_1.normalizeManagementCacheDriver)(options.nativeDriver);
    const responsibilities = (0, Responsibilities_1.createAbsentResponsibilities)(...options.excludedResponsibilities);
    if (responsibilities.has(Responsibility_1.default.POWER)) {
        startBackupRestartChecking(managementDriver, options.baseUrl);
    }
    const propertyStorage = (0, propertyStorage_1.default)(() => cacheDriver);
    const subscriptionType = options.subscriptionType;
    const { excludedResponsibilities: _ } = options, newOptions = __rest(options, ["excludedResponsibilities"]);
    const _a = Object.assign({ responsibilities }, newOptions), { baseUrl, platformUri, staticBaseUrl, uploadBaseUrl, checkInterval, weinreServerUrl: weinreUri, extendedManagementUrl } = _a, sagaOptions = __rest(_a, ["baseUrl", "platformUri", "staticBaseUrl", "uploadBaseUrl", "checkInterval", "weinreServerUrl", "extendedManagementUrl"]);
    const config = { baseUrl, platformUri, staticBaseUrl, uploadBaseUrl, weinreUri, extendedManagementUrl, subscriptionType, checkInterval };
    let lastSagaError;
    const { store, storeEmitter } = yield (0, applicationFactory_1.createApplication)(managementReducers_1.managementReducer, (storage) => (0, managementSagas_1.managementSaga)(config, sagaOptions, storage.getState, propertyStorage), () => managementDriver, (e) => {
        lastSagaError = (0, lodash_1.cloneDeep)(e);
        console.warn('Sagas broken', e);
    });
    if (typeof window !== 'undefined') {
        window.__management = Object.assign(Object.assign({}, options), { store, storeEmitter, lastSagaError });
    }
});
//# sourceMappingURL=management.js.map