import { SubscriptionType } from '../Display/IConfig';
import Responsibility from '../Feature/Responsibility';
import { IBundledApplet } from '../Front/Applet/BundledApplet/bundledAppletActions';
import { ManagementCacheDriver } from '../NativeDevice/Default/combinedDriver';
import IBundledServlet from './Servlet/IBundledServlet';
export interface IManagementOptions {
    baseUrl: string;
    platformUri: string;
    staticBaseUrl: string;
    uploadBaseUrl: string;
    weinreServerUrl: string;
    extendedManagementUrl: string | null;
    pingUrl: string;
    checkInterval: number;
    publicKey: string;
    sessionIdKey: string;
    nativeDriver: ManagementCacheDriver;
    frontDisplayVersion: string;
    applicationVersion: string;
    subscriptionType: SubscriptionType;
    bundledApplet: null | IBundledApplet;
    bundledServlet: IBundledServlet | null;
    autoVerification: {
        organizationUid: string;
        deviceName?: string;
    } | undefined;
    excludedResponsibilities: Responsibility[];
}
declare const _default: (options: IManagementOptions) => Promise<void>;
export default _default;
