"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const t = __importStar(require("./../../Test/TestFramework"));
const should_1 = __importDefault(require("../../Test/should"));
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
exports.default = (nativeDriver) => __awaiter(void 0, void 0, void 0, function* () {
    return t.describe(deviceTestActions_1.TestCase.INFO, function* () {
        yield t.it('Should get serial number', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.SERIAL_NUMBER))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.SERIAL_NUMBER]}" capability`);
            }
            const sn = yield nativeDriver.systemInfo.getSerialNumber();
            (0, should_1.default)(sn).ok();
            (0, should_1.default)(sn.length).be.greaterThanOrEqual(2);
        }));
        yield t.it('Should get model', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.MODEL))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.MODEL]}" capability`);
            }
            const model = yield nativeDriver.systemInfo.getModel();
            (0, should_1.default)(model).ok();
            (0, should_1.default)(model.length).be.greaterThanOrEqual(2);
        }));
        yield t.it('Should get brand', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.BRAND))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.BRAND]}" capability`);
            }
            const brand = yield nativeDriver.systemInfo.getBrand();
            (0, should_1.default)(brand).ok();
            (0, should_1.default)(brand.length).be.greaterThanOrEqual(2);
        }));
        yield t.it('Should get firmware version', () => __awaiter(this, void 0, void 0, function* () {
            const fw = yield nativeDriver.firmwareGetVersion();
            (0, should_1.default)(fw).be.ok();
        }));
        yield t.it('Should get application type', () => __awaiter(this, void 0, void 0, function* () {
            const appType = yield nativeDriver.getApplicationType();
            (0, should_1.default)(appType).be.ok();
        }));
        yield t.it('Should get network info', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.NETWORK_INFO))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.NETWORK_INFO]}" capability`);
            }
            const networkInterfaces = yield nativeDriver.network.listInterfaces();
            (0, should_1.default)(networkInterfaces).be.Array();
            (0, should_1.default)(networkInterfaces).be.not.empty();
            for (let networkInterface of networkInterfaces) {
                (0, should_1.default)(networkInterface.type).be.oneOf(['wifi', 'ethernet']);
                should_1.default.exist(networkInterface.macAddress);
                if (networkInterface.localAddress) {
                    should_1.default.exist(networkInterface.netmask);
                    should_1.default.exist(networkInterface.gateway);
                }
                else {
                    should_1.default.not.exist(networkInterface.netmask);
                    should_1.default.not.exist(networkInterface.gateway);
                    // should.not.exist(networkInterface.dns);
                }
            }
        }));
        yield t.it('Should get current temperature', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.TEMPERATURE))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.TEMPERATURE]}" capability`);
            }
            const temp = yield nativeDriver.getCurrentTemperature();
            (0, should_1.default)(temp).be.greaterThan(0);
            (0, should_1.default)(temp).be.lessThan(999);
        }));
        yield t.it('Should get current cpu usage', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.SYSTEM_CPU))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.SYSTEM_CPU]}" capability`);
            }
            const systemCpuUsage = yield nativeDriver.systemInfo.getCpuUsage();
            (0, should_1.default)(systemCpuUsage).be.ok();
            (0, should_1.default)(systemCpuUsage).be.greaterThanOrEqual(0);
        }));
        yield t.it('Should get current memory usage', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.SYSTEM_MEMORY))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.SYSTEM_MEMORY]}" capability`);
            }
            const systemMemoryUsage = yield nativeDriver.systemInfo.getMemoryUsage();
            (0, should_1.default)(systemMemoryUsage).be.ok();
            (0, should_1.default)(systemMemoryUsage.free).be.greaterThanOrEqual(0);
            (0, should_1.default)(systemMemoryUsage.total).be.greaterThanOrEqual(0);
            (0, should_1.default)(systemMemoryUsage.used).be.greaterThanOrEqual(0);
        }));
        yield t.it('Should get proxy connect status', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.PROXY))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.PROXY]}" capability`);
            }
            const proxyInfo = yield nativeDriver.proxy.isEnabled();
            (0, should_1.default)(proxyInfo).is.Boolean();
            if (proxyInfo) {
                const proxyUri = yield nativeDriver.proxy.getConnectedTo();
                (0, should_1.default)(proxyUri).not.be.undefined();
            }
        }));
    });
});
//# sourceMappingURL=InfoTest.js.map