"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const t = __importStar(require("./../../Test/TestFramework"));
const should_1 = __importDefault(require("../../Test/should"));
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
exports.default = (nativeDriver, responsibilities) => __awaiter(void 0, void 0, void 0, function* () {
    return t.describe(deviceTestActions_1.TestCase.DISPLAY, function* () {
        yield t.it('Should power on/off display', () => __awaiter(this, void 0, void 0, function* () {
            if (!responsibilities.has(Responsibility_1.default.POWER)) {
                // Android app can't test display power ON/OFF automatically.
                // Test runs inside WebView and the WebView is unloaded on display OFF.
                // This is an abuse of Responsibility.POWER and a hack!
                t.skip(`Power management tests are disabled on this device.`);
            }
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.DISPLAY_POWER))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default.DISPLAY_POWER}" capability`);
            }
            const isOn = yield nativeDriver.displayIsPowerOn();
            if (isOn) {
                yield nativeDriver.displayPowerOff();
                (0, should_1.default)(yield nativeDriver.displayIsPowerOn()).be.false();
                yield nativeDriver.displayPowerOn();
                (0, should_1.default)(yield nativeDriver.displayIsPowerOn()).be.true();
            }
            else {
                yield nativeDriver.displayPowerOn();
                (0, should_1.default)(yield nativeDriver.displayIsPowerOn()).be.true();
                yield nativeDriver.displayPowerOff();
                (0, should_1.default)(yield nativeDriver.displayIsPowerOn()).be.false();
            }
        }));
        yield t.it('Should set the screen brightness', () => __awaiter(this, void 0, void 0, function* () {
            if (!(yield nativeDriver.managementSupports(ManagementCapability_1.default.SET_BRIGHTNESS))) {
                t.skip(`The device does not provide "${ManagementCapability_1.default[ManagementCapability_1.default.SET_BRIGHTNESS]}" capability`);
            }
            const br = yield nativeDriver.screenGetBrightness();
            (0, should_1.default)(br).be.ok();
            should_1.default.exist(br.timeFrom1);
            should_1.default.exist(br.brightness1);
            should_1.default.exist(br.timeFrom2);
            should_1.default.exist(br.brightness2);
            yield nativeDriver.screenSetBrightness('00:00:00', 90, '23:59:59', 30);
            if (yield nativeDriver.managementSupports(ManagementCapability_1.default.BRIGHTNESS_SCHEDULING)) {
                // Some platforms do not returns seconds in the time string
                const newBrightness = yield nativeDriver.screenGetBrightness();
                (0, should_1.default)(newBrightness).be.ok();
                (0, should_1.default)(newBrightness.timeFrom1).containEql('00:00');
                (0, should_1.default)(newBrightness.brightness1).equal(90);
                (0, should_1.default)(newBrightness.timeFrom2).containEql('23:59');
                (0, should_1.default)(newBrightness.brightness2).equal(30);
            }
            else {
                const newBrightness = yield nativeDriver.screenGetBrightness();
                (0, should_1.default)(newBrightness.brightness1).equal(90);
            }
            yield nativeDriver.screenSetBrightness(br.timeFrom1, br.brightness1, br.timeFrom2, br.brightness2);
        }));
    });
});
//# sourceMappingURL=DisplayTest.js.map