"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.systemLogsSaga = void 0;
const effects_1 = require("redux-saga/effects");
const deviceTelemetryActions_1 = require("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions");
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const systemLogs_1 = require("@signageos/common-types/dist/Device/SystemLogs/systemLogs");
const systemLogActionFactory_1 = require("../../SystemLogs/systemLogActionFactory");
function* systemLogsSaga() {
    yield (0, effects_1.takeEvery)(deviceTelemetryActions_1.UpdateDeviceTelemetryRecord, function* (action) {
        if (action.name === DeviceSettingsType_1.DeviceSettingsType.DATETIME) {
            yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
                type: systemLogs_1.TimeSettingsChanged,
            }));
        }
    });
}
exports.systemLogsSaga = systemLogsSaga;
//# sourceMappingURL=systemLogsSagas.js.map