"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runServlets = exports.runBundledServlet = exports.subscribeActiveServlets = void 0;
const effects_1 = require("redux-saga/effects");
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
const servletActions_1 = require("@signageos/actions/dist/Servlet/servletActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const HashAlgorithm_1 = __importDefault(require("../../NativeDevice/HashAlgorithm"));
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const capable_1 = require("../../Feature/capable");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
function* subscribeActiveServlets(getState, responsibilities, getNativeDriver) {
    if (!responsibilities.has(Responsibility_1.default.SERVLET)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)([authenticationActions_1.AuthenticationSucceed, deviceVerificationActions_1.VerificationSucceeded]);
    const driver = getNativeDriver();
    const supportsServlet = yield driver.managementSupports(ManagementCapability_1.default.SERVLET);
    if (supportsServlet) {
        yield (0, effects_1.takeEvery)([authenticationActions_1.AuthenticationSucceed, deviceVerificationActions_1.VerificationSucceeded], function* (action) {
            try {
                switch (action.type) {
                    case authenticationActions_1.AuthenticationSucceed:
                        const state = getState();
                        if (state.deviceVerification.verified) {
                            yield (0, effects_1.put)({
                                type: servletActions_1.SubscribeActiveServlet,
                            });
                        }
                        break;
                    case deviceVerificationActions_1.VerificationSucceeded:
                        yield (0, effects_1.put)({
                            type: servletActions_1.SubscribeActiveServlet,
                        });
                        break;
                    default:
                }
            }
            catch (error) {
                console.error('subscribeActiveServlets failed', error);
            }
        });
    }
}
exports.subscribeActiveServlets = subscribeActiveServlets;
function* runBundledServlet(responsibilities, bundledServlet) {
    if (!responsibilities.has(Responsibility_1.default.SERVLET)) {
        return;
    }
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SERVLET, (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }) {
        if (bundledServlet) {
            try {
                const options = {
                    env: bundledServlet.env,
                    healthcheck: bundledServlet.healthcheck,
                };
                managementDriver.servletRunner.run(bundledServlet.filePath, options);
            }
            catch (error) {
                console.error('runServlets', error);
            }
        }
    })));
}
exports.runBundledServlet = runBundledServlet;
function* runServlets(responsibilities, offlineCache) {
    if (!responsibilities.has(Responsibility_1.default.SERVLET)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(servletActions_1.UpdateActiveServlets);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SERVLET, (0, dependencyInjection_1.withDependencies)(['staticBaseUrl', 'managementDriver'], function* ({ staticBaseUrl, managementDriver }) {
        yield (0, effects_1.takeEvery)(servletActions_1.UpdateActiveServlets, function* (action) {
            try {
                yield Promise.all(action.servlets.map((servlet) => __awaiter(this, void 0, void 0, function* () {
                    yield downloadAndExtractServlet(offlineCache, staticBaseUrl, servlet.uid, servlet.version, servlet.checksum);
                    const options = {
                        env: servlet.env,
                        // TODO add healthcheck option for remote servlets
                        //healthcheck: servlet.healthcheck,
                    };
                    yield runServlet(managementDriver, offlineCache, servlet.uid, servlet.version, options);
                })));
            }
            catch (error) {
                console.error('runServlets', error);
            }
        });
    })));
}
exports.runServlets = runServlets;
function downloadAndExtractServlet(offlineCache, staticBaseUrl, servletUid, servletVersion, servletChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        const EXTRACT_METHOD = 'zip';
        try {
            const servletDirectoryName = getServletDirectoryName(servletUid, servletVersion);
            const servletArchiveFileName = getServletArchiveFileName(servletUid, servletVersion);
            const servletDirectoryExists = yield offlineCache.fileExists(servletDirectoryName);
            if (!servletDirectoryExists) {
                yield downloadServletArchiveToLocalStorage(offlineCache, staticBaseUrl, servletUid, servletVersion);
                yield validateServletArchiveChecksum(offlineCache, servletArchiveFileName, servletChecksum);
                yield offlineCache.extractFile(servletArchiveFileName, servletDirectoryName, EXTRACT_METHOD, true);
                yield offlineCache.deleteFile(servletArchiveFileName, false);
            }
        }
        catch (error) {
            console.error('Error while downloading servlet archive', 'uid: ' + servletUid + ', version: ' + servletVersion, error);
        }
    });
}
function validateServletArchiveChecksum(offlineCache, archiveFileName, expectedChecksum) {
    return __awaiter(this, void 0, void 0, function* () {
        const CHECKSUM_HASH_ALGORITHM = HashAlgorithm_1.default.MD5;
        const servletArchiveChecksum = yield offlineCache.getFileChecksum(archiveFileName, CHECKSUM_HASH_ALGORITHM);
        if (servletArchiveChecksum !== expectedChecksum) {
            throw new Error("Checksum of downloaded servlet archive doesn't match expected checksum");
        }
    });
}
function downloadServletArchiveToLocalStorage(offlineCache, staticBaseUrl, servletUid, servletVersion) {
    return __awaiter(this, void 0, void 0, function* () {
        const servletArchiveFileName = getServletArchiveFileName(servletUid, servletVersion);
        const servletArchiveUri = getServletArchiveDownloadUri(staticBaseUrl, servletUid, servletVersion);
        const DOWNLOAD_RETRIES = 5;
        yield offlineCache.retriableDownloadFile(DOWNLOAD_RETRIES, servletArchiveFileName, servletArchiveUri, undefined, true);
        return yield offlineCache.getFile(servletArchiveFileName);
    });
}
function runServlet(managementDriver, offlineCache, servletUid, servletVersion, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const servletDirectory = getServletDirectoryName(servletUid, servletVersion);
        const servletPackageJson = servletDirectory + '/package.json';
        const servletPackageJsonExists = yield offlineCache.fileExists(servletPackageJson);
        if (!servletPackageJsonExists) {
            throw new Error('Servlet package is not a valid npm module, missing package.json');
        }
        const servletPackageJsonContents = yield offlineCache.readFile(servletPackageJson);
        const mainFileName = JSON.parse(servletPackageJsonContents).main || 'index.js';
        const mainFile = servletDirectory + '/' + mainFileName;
        const mainFilePath = yield offlineCache.getFullFilePath(mainFile);
        managementDriver.servletRunner.run(mainFilePath, options);
    });
}
function getServletArchiveFileName(servletUid, servletVersion) {
    return `servlet/${servletUid}/${servletVersion}.zip`;
}
function getServletDirectoryName(servletUid, servletVersion) {
    return `servlet/${servletUid}/${servletVersion}`;
}
function getServletArchiveDownloadUri(staticBaseUrl, servletUid, servletVersion) {
    return `${staticBaseUrl}/servlet/${servletUid}/${servletVersion}.zip`;
}
//# sourceMappingURL=servletSagas.js.map