export interface SecretStorage {
    saveKeyPair(name: string, key: RsaKeyPairData): Promise<void>;
    getKeyPair(name: string): Promise<RsaKeyPairData | null>;
}
export interface RsaKeyPairData {
    algorithm: RsaHashedKeyAlgorithm;
    publicKeySpki: string;
    privateKeyPkcs8: string;
    keyValidity: {
        start: Date;
        end: Date;
    };
}
