"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.instantScreenshotSaga = exports.periodicScreenshotSaga = void 0;
const effects_1 = require("redux-saga/effects");
const deviceScreenshotActions_1 = require("@signageos/actions/dist/Device/Screenshot/deviceScreenshotActions");
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const screenshotActions_1 = require("@signageos/actions/dist/Screen/screenshotActions");
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const capable_1 = require("../../Feature/capable");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const deviceTelemetryHelper_1 = require("../Device/Telemetry/deviceTelemetryHelper");
const isOnline_1 = require("../../Util/isOnline");
const RECOVERING_DELAY = 30 * 60e3;
function* periodicScreenshotSaga(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.SCREENSHOT)) {
        return;
    }
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SCREENSHOT_UPLOAD, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'uploadBaseUrl', 'telemetryIntervals', 'pingUrl', 'featureFlags'], function* ({ managementDriver, uploadBaseUrl, telemetryIntervals, pingUrl, featureFlags }) {
        var _a;
        const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals.screenshots) !== null && _a !== void 0 ? _a : 0;
        let tryRecoverScreenshotsWhenFirewallBlocks = false;
        yield (0, deviceTelemetryHelper_1.registerTelemetry)('SCREENSHOT', periodMs, function* () {
            var _a;
            try {
                const onLine = yield (0, isOnline_1.isOnline)(pingUrl);
                const isOnlineOrRecovering = onLine || tryRecoverScreenshotsWhenFirewallBlocks;
                const isScreenshotCaptureEnabled = (_a = featureFlags === null || featureFlags === void 0 ? void 0 : featureFlags.screenshotCapture) !== null && _a !== void 0 ? _a : true;
                if (isOnlineOrRecovering && isScreenshotCaptureEnabled) {
                    // Do not try if device is offline
                    yield takeScreenshot(managementDriver, uploadBaseUrl, true);
                }
            }
            catch (error) {
                // In case of navigator.onLine is not working because of firewall, do try recovery after 30 minutes
                tryRecoverScreenshotsWhenFirewallBlocks = false;
                setTimeout(() => (tryRecoverScreenshotsWhenFirewallBlocks = true), RECOVERING_DELAY);
                console.error('screenshotSaga', error);
            }
        });
    })));
}
exports.periodicScreenshotSaga = periodicScreenshotSaga;
function* instantScreenshotSaga(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.SCREENSHOT)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceScreenshotActions_1.TakeInstantScreenshot);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SCREENSHOT_UPLOAD, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'uploadBaseUrl', 'featureFlags'], function* ({ managementDriver, uploadBaseUrl, featureFlags }) {
        var _a;
        if ((_a = featureFlags === null || featureFlags === void 0 ? void 0 : featureFlags.screenshotCapture) !== null && _a !== void 0 ? _a : true) {
            yield (0, effects_1.takeEvery)(deviceScreenshotActions_1.TakeInstantScreenshot, function* () {
                try {
                    yield takeScreenshot(managementDriver, uploadBaseUrl, true);
                }
                catch (error) {
                    console.error('instantScreenshotSaga', error);
                }
            });
        }
    })));
}
exports.instantScreenshotSaga = instantScreenshotSaga;
function* takeScreenshot(nativeDriver, uploadBaseUrl, computeHash) {
    const screenshotUri = yield nativeDriver.screenshotUpload(uploadBaseUrl, computeHash);
    yield (0, effects_1.put)({
        type: screenshotActions_1.SaveTakenScreenshot,
        screenshotUri: screenshotUri.url,
        imageHashes: Object.assign({}, screenshotUri.imageInformations),
    });
}
//# sourceMappingURL=screenshotSaga.js.map