"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyDeviceApplicationVersion = exports.notifyDeviceSaga = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const deviceSagas_1 = require("../../Device/deviceSagas");
function* notifyDeviceSaga(getNativeDriver, responsibilities) {
    if (responsibilities.has(Responsibility_1.default.DEVICE)) {
        yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, deviceSagas_1.notifyDeviceInfo, getNativeDriver);
    }
    if (responsibilities.has(Responsibility_1.default.PROXY)) {
        yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, deviceSagas_1.notifyDeviceProxyInfo, getNativeDriver);
    }
}
exports.notifyDeviceSaga = notifyDeviceSaga;
function* notifyDeviceApplicationVersion(getNativeDriver, responsibilities, applicationVersion) {
    if (!responsibilities.has(Responsibility_1.default.APP)) {
        return;
    }
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, deviceSagas_1.notifyDeviceApplicationVersionCommon, getNativeDriver, applicationVersion);
}
exports.notifyDeviceApplicationVersion = notifyDeviceApplicationVersion;
//# sourceMappingURL=deviceSagas.js.map