"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sortByTimerTypeCallback = exports.checkAndSetProprietaryTimersSettings = exports.checkAndSetTimersSettings = exports.deviceProprietaryTimerPolicySaga = exports.deviceTimerPolicySaga = void 0;
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const devicePolicySagas_1 = require("../Policy/devicePolicySagas");
const lodash_1 = __importDefault(require("lodash"));
const deviceTimerTelemetrySagas_1 = require("./deviceTimerTelemetrySagas");
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const TimerType_1 = __importDefault(require("../../../NativeDevice/Timer/TimerType"));
exports.deviceTimerPolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.TIMERS, Responsibility_1.default.TIMERS, ManagementCapability_1.default.TIMERS_NATIVE, checkAndSetTimersSettings);
exports.deviceProprietaryTimerPolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.PROPRIETARY_TIMERS, Responsibility_1.default.TIMERS, ManagementCapability_1.default.TIMERS_PROPRIETARY, checkAndSetProprietaryTimersSettings);
function checkAndSetTimersSettings(properties) {
    return __asyncGenerator(this, arguments, function* checkAndSetTimersSettings_1() {
        const newTimersSettings = properties.policy.value;
        const currentTimersSettings = yield __await((0, deviceTimerTelemetrySagas_1.getNativeTimers)(properties));
        if (!lodash_1.default.isEqual(normalizeTimers(newTimersSettings), normalizeTimers(currentTimersSettings))) {
            for (let timerSettings of newTimersSettings) {
                yield __await(properties.managementDriver.setTimer(TimerType_1.default[timerSettings.type], timerSettings.timeOn, timerSettings.timeOff, convertWeekday_1.convertWeekday.fromLong(timerSettings.weekdays).toTimerWeekday(), timerSettings.volume));
            }
            const timersToRemove = currentTimersSettings.filter((currentTimer) => !newTimersSettings.some((newTimer) => currentTimer.type === newTimer.type));
            for (const { type } of timersToRemove) {
                yield yield __await(properties.managementDriver.setTimer(TimerType_1.default[type], null, null, [], 0));
            }
            return yield __await(devicePolicySagas_1.CheckAndSetResult.CHANGED);
        }
        return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
    });
}
exports.checkAndSetTimersSettings = checkAndSetTimersSettings;
function checkAndSetProprietaryTimersSettings(properties) {
    return __asyncGenerator(this, arguments, function* checkAndSetProprietaryTimersSettings_1() {
        const newTimersSettings = properties.policy.value;
        const currentTimersSettings = yield __await((0, deviceTimerTelemetrySagas_1.getProprietaryTimers)(properties));
        if (!lodash_1.default.isEqual(normalizeTimers(newTimersSettings), normalizeTimers(currentTimersSettings))) {
            for (const timerSettings of newTimersSettings) {
                yield __await(properties.timerStorage.setShortTimer({
                    type: timerSettings.type,
                    timeOn: typeof timerSettings.timeOn === 'string' ? timerSettings.timeOn.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
                    timeOff: typeof timerSettings.timeOff === 'string' ? timerSettings.timeOff.replace(/^(\d{2}):(\d{2}).*/, '$1:$2:00') : null,
                    weekdays: convertWeekday_1.convertWeekday.fromLong(timerSettings.weekdays).toShort(),
                }));
            }
            const timersToRemove = currentTimersSettings.filter((currentTimer) => !newTimersSettings.some((newTimer) => currentTimer.type === newTimer.type));
            for (const { type } of timersToRemove) {
                yield yield __await(properties.timerStorage.deleteTimer(type));
            }
            return yield __await(devicePolicySagas_1.CheckAndSetResult.CHANGED);
        }
        return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
    });
}
exports.checkAndSetProprietaryTimersSettings = checkAndSetProprietaryTimersSettings;
function sortByTimerTypeCallback(a, b) {
    if (a.type < b.type) {
        return -1;
    }
    if (a.type > b.type) {
        return 1;
    }
    return 0;
}
exports.sortByTimerTypeCallback = sortByTimerTypeCallback;
function normalizeTimers(timers) {
    let outputTimers = lodash_1.default.cloneDeep(timers);
    outputTimers.forEach((timer) => timer.weekdays.sort());
    outputTimers.sort(sortByTimerTypeCallback);
    return outputTimers;
}
//# sourceMappingURL=deviceTimerPolicySagas.js.map