"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceTelemetrySaga = void 0;
const effects_1 = require("redux-saga/effects");
const deviceVolumeTelemetrySagas_1 = require("../../Device/Audio/deviceVolumeTelemetrySagas");
const brightnessTelemetrySagas_1 = require("../../Device/Brightness/brightnessTelemetrySagas");
const deviceResolutionTelemetrySagas_1 = require("../../Device/Screen/deviceResolutionTelemetrySagas");
const deviceOrientationTelemetrySagas_1 = require("../../Device/Screen/deviceOrientationTelemetrySagas");
const deviceRemoteControlTelemetrySagas_1 = require("../../Device/RemoteControl/deviceRemoteControlTelemetrySagas");
const deviceApplicationTelemetrySagas_1 = require("../../Device/Application/deviceApplicationTelemetrySagas");
const deviceFirmwareTelemetrySagas_1 = require("../../Device/Firmware/deviceFirmwareTelemetrySagas");
const deviceDebugTelemetrySagas_1 = require("../../Device/Debug/deviceDebugTelemetrySagas");
const deviceDateTimeTelemetrySagas_1 = require("../../Device/DateTime/deviceDateTimeTelemetrySagas");
const devicePowerActionTelemetrySagas_1 = require("../../Device/Power/devicePowerActionTelemetrySagas");
const deviceTimerTelemetrySagas_1 = require("../../Device/Timer/deviceTimerTelemetrySagas");
const temperatureTelemetrySagas_1 = require("../../Device/Temperature/temperatureTelemetrySagas");
const deviceBundledAppletTelemetrySagas_1 = require("../../Device/BundledApplet/deviceBundledAppletTelemetrySagas");
const deviceProxyTelemetrySaga_1 = require("../Proxy/deviceProxyTelemetrySaga");
const deviceWifiStrengthTelemetrySaga_1 = require("../Network/deviceWifiStrengthTelemetrySaga");
const autoRecoveryTelemetrySaga_1 = require("../AutoRecovery/autoRecoveryTelemetrySaga");
const peerRecoveryTelemetrySaga_1 = require("../PeerRecovery/peerRecoveryTelemetrySaga");
const deviceCapabilitiesTelemetrySagas_1 = require("../Capabilities/deviceCapabilitiesTelemetrySagas");
const extendedManagementTelemetrySagas_1 = require("../../Extended/extendedManagementTelemetrySagas");
const deviceNetworkTelemetrySaga_1 = require("../Network/deviceNetworkTelemetrySaga");
const telemetryDisplayPowerOnSaga_1 = require("../Display/telemetryDisplayPowerOnSaga");
const telemetryAppModulesSaga_1 = require("../AppModules/telemetryAppModulesSaga");
const deviceFeatureFlegsTelemetrySaga_1 = require("../../FeatureFlags/deviceFeatureFlegsTelemetrySaga");
const deviceCryphotraphicTelemetrySaga_1 = require("../Secrets/deviceCryphotraphicTelemetrySaga");
const deviceTelemetrySaga = (responsibilities, getNativeDriver, propertyStorage, proprietaryTimerStorage, applicationVersion, powerActionTimer) => function* () {
    const powerActionRules = () => __awaiter(this, void 0, void 0, function* () { return yield powerActionTimer.rules(); });
    const telemetrySagas = [
        deviceVolumeTelemetrySagas_1.telemetryDeviceVolumeSaga,
        brightnessTelemetrySagas_1.telemetryBrightnessSettingsSaga,
        deviceResolutionTelemetrySagas_1.telemetryResolutionSaga,
        deviceOrientationTelemetrySagas_1.telemetryOrientationSaga,
        deviceRemoteControlTelemetrySagas_1.telemetryDeviceRemoteControlSaga,
        deviceApplicationTelemetrySagas_1.telemetryDeviceApplicationSaga,
        deviceFirmwareTelemetrySagas_1.telemetryDeviceFirmwareSaga,
        deviceDebugTelemetrySagas_1.telemetryDeviceDebugSaga,
        deviceDateTimeTelemetrySagas_1.telemetryDeviceDateTimeSaga,
        devicePowerActionTelemetrySagas_1.telemetryDevicePowerActionsSaga,
        deviceTimerTelemetrySagas_1.telemetryDeviceTimerSaga,
        deviceTimerTelemetrySagas_1.telemetryDeviceProprietaryTimerSaga,
        temperatureTelemetrySagas_1.telemetryTemperatureSettingsSaga,
        deviceBundledAppletTelemetrySagas_1.telemetryDeviceBundledAppletSaga,
        deviceNetworkTelemetrySaga_1.telemetryNetworkInfo,
        deviceProxyTelemetrySaga_1.telemetryDeviceProxySaga,
        deviceWifiStrengthTelemetrySaga_1.telemetryDeviceWifiStrenghtSaga,
        autoRecoveryTelemetrySaga_1.telemetryDeviceAutoRecoverySaga,
        peerRecoveryTelemetrySaga_1.telemetryDevicePeerRecoverySaga,
        deviceCapabilitiesTelemetrySagas_1.telemetryManagementCapabilitiesSaga,
        extendedManagementTelemetrySagas_1.telemetryExtendedManagementSettingsSaga,
        telemetryDisplayPowerOnSaga_1.telemetryDisplayPowerOnSaga,
        telemetryAppModulesSaga_1.telemetryAppModulesSaga,
        deviceFeatureFlegsTelemetrySaga_1.telemetryFeatureFlagsSaga,
        deviceCryphotraphicTelemetrySaga_1.telemetryCryptographicSaga,
    ];
    const telemetrySagaIterators = telemetrySagas.map((saga) => {
        return saga(responsibilities, getNativeDriver, propertyStorage, proprietaryTimerStorage, powerActionRules, applicationVersion);
    });
    yield (0, effects_1.all)(telemetrySagaIterators);
};
exports.deviceTelemetrySaga = deviceTelemetrySaga;
//# sourceMappingURL=deviceTelemetrySaga.js.map