import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
/**
 * Calculates the initial delay in ms before sending the first telemetry data.
 * It's a random value between TELEMETRY_INITIAL_DELAY and TELEMETRY_INITIAL_DELAY + TELEMETRY_INITIAL_RANDOM_DELAY.
 */
export declare function calculateInitialTelemetryTimeoutMs(): number;
/**
 * The generic function that registers any kind of telemetry.
 *
 * @param type It's currently used only for debug logs. For some old telemetry it can be used plain string because it's not a part of TelemetryType enum yet.
 * @param periodMs How often the telemetry will be sent.
 * Negative values mean the telemetry is disabled.
 * Zero value means the only initial telemetry is sent and then it's disabled.
 * Values greater than zero mean periodic telemetry in milliseconds.
 * @param performTelemetry The function that performs the telemetry.
 */
export declare const registerTelemetry: <Type extends DeviceTelemetryType, TPerformTelemetry extends () => Generator>(type: string | Type, periodMs: number, performTelemetry: TPerformTelemetry) => import("redux-saga/effects").ForkEffect<any>;
