"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkKeyPairValidity = exports.cryptographySaga = exports.regenerateKeyPair = exports.CryptographicKeyChanged = void 0;
const secretActions_1 = require("@signageos/actions/dist/Device/Secrets/secretActions");
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const capable_1 = require("../../../Feature/capable");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const Property_1 = __importDefault(require("../../../Property/Property"));
exports.CryptographicKeyChanged = 'Secrets.CryptographicKeyChanged';
function* regenerateKeyPair(getNativeDriver, action) {
    const nativeDriver = getNativeDriver();
    try {
        yield nativeDriver.secretManager.generateKeys();
        const keyPairData = yield nativeDriver.secretManager.getPublicKey();
        if (!keyPairData) {
            throw new Error('Failed to get public key');
        }
        yield (0, effects_1.put)({
            type: secretActions_1.RegenerateCryptoKeyPairSucceeded,
            uid: action.uid,
            publicKey: keyPairData.publicKeySpki,
        });
    }
    catch (error) {
        yield (0, effects_1.put)({
            type: secretActions_1.RegenerateCryptoKeyPairFailed,
            uid: action.uid,
        });
    }
}
exports.regenerateKeyPair = regenerateKeyPair;
function* cryptographySaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.SECRET_MANAGEMENT)) {
        return;
    }
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(secretActions_1.RegenerateCryptoKeyPair, regenerateKeyPair, getNativeDriver);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SECRETS, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'propertyStorage'], function* ({ managementDriver, propertyStorage }) {
        const isGenerated = yield propertyStorage.getValueOrDefault(Property_1.default.LATEST_REPORTED_SETTINGS_CRYPTOGRAPHIC_KEY, null);
        if (isGenerated === null) {
            try {
                yield managementDriver.secretManager.generateKeys();
                yield (0, effects_1.put)({
                    type: exports.CryptographicKeyChanged,
                });
            }
            catch (error) {
                console.error('generateCryptographicKeys failed', error);
            }
        }
        else {
            yield checkKeyPairValidity();
        }
    })));
}
exports.cryptographySaga = cryptographySaga;
function* checkKeyPairValidity() {
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SECRETS, (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }) {
        try {
            const publicKeyData = yield managementDriver.secretManager.getPublicKey();
            if (publicKeyData && publicKeyData.keyValidity && publicKeyData.keyValidity.end) {
                const currentDate = new Date();
                const validityEndDate = new Date(publicKeyData.keyValidity.end);
                if (currentDate >= validityEndDate) {
                    try {
                        yield managementDriver.secretManager.generateKeys();
                        yield (0, effects_1.put)({
                            type: exports.CryptographicKeyChanged,
                        });
                    }
                    catch (error) {
                        console.error('generateCryptographicKeys failed', error);
                    }
                }
            }
        }
        catch (error) {
            console.error('checkKeyPairValidity failed', error);
        }
    })));
}
exports.checkKeyPairValidity = checkKeyPairValidity;
//# sourceMappingURL=deviceCryptographicSaga.js.map