"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportScreen = exports.resizeScreen = exports.deviceResizeCallback = exports.deviceSupportedResolutionsCallback = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceResolutionActions_1 = require("@signageos/actions/dist/Device/Resolution/deviceResolutionActions");
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const debug_1 = __importDefault(require("debug"));
const Orientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/Orientation"));
const VideoOrientation_1 = __importDefault(require("@signageos/common-types/dist/Device/Resolution/VideoOrientation"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const capable_1 = require("../../../Feature/capable");
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
const debug = (0, debug_1.default)('@signageos/front-display:Device:Screeb:deviceScreenResizeSagas');
function* deviceSupportedResolutionsCallback(managementDriver) {
    debug('deviceSupportedResolutionsCallback called');
    try {
        const supportedResolutions = yield managementDriver.getSupportedResolutions();
        debug('supportedResolutions', supportedResolutions);
        yield (0, effects_1.put)({
            type: deviceResolutionActions_1.NotifySupportedResolutions,
            supportedResolutions,
        });
    }
    catch (error) {
        console.error('automatic getting of supported resolutions not supported', error);
    }
}
exports.deviceSupportedResolutionsCallback = deviceSupportedResolutionsCallback;
function* deviceResizeCallback(managementDriver, staticBaseUrl, applicationVersion, action) {
    try {
        const finalizeCallback = yield (0, effects_1.apply)(managementDriver, managementDriver.screenResize, [
            staticBaseUrl,
            Orientation_1.default[action.screenOrientation],
            action.screenSize,
            applicationVersion,
            action.videoOrientation ? VideoOrientation_1.default[action.videoOrientation] : undefined,
        ]);
        yield (0, effects_1.put)({
            type: deviceResolutionActions_1.DeviceResizeSucceeded,
            uid: action.uid,
        });
        yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
    }
    catch (error) {
        console.error('resizeScreen failed', error);
        yield (0, effects_1.put)({
            type: deviceResolutionActions_1.DeviceResizeFailed,
            uid: action.uid,
        });
    }
}
exports.deviceResizeCallback = deviceResizeCallback;
function* resizeScreen(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.SCREEN)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceResolutionActions_1.DeviceResize);
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SCREEN_RESIZE, (0, dependencyInjection_1.withDependencies)(['applicationVersion', 'managementDriver', 'staticBaseUrl'], function* ({ applicationVersion, managementDriver, staticBaseUrl }) {
        yield (0, effects_1.takeEvery)(deviceResolutionActions_1.DeviceResize, deviceResizeCallback, managementDriver, staticBaseUrl, applicationVersion);
    })));
}
exports.resizeScreen = resizeScreen;
function* reportScreen(responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.SCREEN)) {
        return;
    }
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SCREEN_RESIZE, (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }) {
        yield (0, effects_1.takeEvery)(socketActions_1.SocketConnected, deviceSupportedResolutionsCallback, managementDriver);
    })));
}
exports.reportScreen = reportScreen;
//# sourceMappingURL=deviceScreenResizeSagas.js.map