"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowerFacade = void 0;
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const systemLogActions_1 = require("@signageos/actions/dist/SystemLog/systemLogActions");
const managementHelper_1 = require("../../managementHelper");
const combinedDriver_1 = require("../../../NativeDevice/Default/combinedDriver");
const systemLogs_1 = require("@signageos/common-types/dist/Device/SystemLogs/systemLogs");
class PowerFacade {
    constructor(nativeDriver, actionUploader, powerKernel) {
        this.nativeDriver = nativeDriver;
        this.actionUploader = actionUploader;
        this.powerKernel = powerKernel;
    }
    performPowerAction(powerType) {
        return __awaiter(this, void 0, void 0, function* () {
            const { managementDriver, cacheDriver } = (0, combinedDriver_1.normalizeManagementCacheDriver)(this.nativeDriver);
            const powerAction = {
                type: systemLogActions_1.SystemLog,
                payload: {
                    type: systemLogs_1.PowerActionPerformed,
                    action: PowerActionType_1.default[powerType],
                },
                __dispatchedAt: new Date(),
                __offline: true,
            };
            // In this case we cannot listen to succeed action because power action is trigger so we append action directly to offlineAction file
            yield this.actionUploader.addAction(powerAction);
            switch (powerType) {
                case PowerActionType_1.default.APP_RESTART:
                    yield this.powerKernel.appRestart();
                    return true;
                case PowerActionType_1.default.SYSTEM_REBOOT:
                    yield this.powerKernel.systemReboot();
                    return true;
                case PowerActionType_1.default.DISPLAY_POWER_ON:
                    yield managementDriver.displayPowerOn();
                    return true;
                case PowerActionType_1.default.DISPLAY_POWER_OFF:
                    yield managementDriver.displayPowerOff();
                    return true;
                case PowerActionType_1.default.FILE_SYSTEM_WIPEOUT:
                    yield (0, managementHelper_1.fileSystemWipeoutAction)(managementDriver, cacheDriver);
                    yield (0, wait_1.default)(1e3);
                    yield this.powerKernel.systemReboot();
                    return true;
                default:
                    return false;
            }
        });
    }
}
exports.PowerFacade = PowerFacade;
//# sourceMappingURL=powerFacade.js.map