"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createManagementPowerActionTimer = void 0;
const CronPowerActionScheduler_1 = __importDefault(require("../../../NativeDevice/Power/CronPowerActionScheduler"));
const DefaultPowerActionTimer_1 = __importDefault(require("../../../NativeDevice/Power/DefaultPowerActionTimer"));
const powerActionTimerStorages_1 = require("../../../NativeDevice/Power/powerActionTimerStorages");
const Property_1 = __importDefault(require("../../../Property/Property"));
const propertyStorage_1 = __importDefault(require("../../../Property/propertyStorage"));
const ManagementPowerActionExecutor_1 = __importDefault(require("./ManagementPowerActionExecutor"));
function createManagementPowerActionTimer(getNativeDriver, powerFacade) {
    const propertyStorage = (0, propertyStorage_1.default)(getNativeDriver);
    const storage = (0, powerActionTimerStorages_1.createPowerActionTimerPropertyStorage)(propertyStorage, Property_1.default.POWER_ACTIONS_SCHEDULE_SETTINGS_MANAGEMENT);
    const scheduler = new CronPowerActionScheduler_1.default();
    const executor = new ManagementPowerActionExecutor_1.default(powerFacade);
    return new DefaultPowerActionTimer_1.default(storage, scheduler, executor);
}
exports.createManagementPowerActionTimer = createManagementPowerActionTimer;
//# sourceMappingURL=powerActionTimers.js.map