"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceDisplayPowerAction = exports.devicePerformScheduledPowerAction = exports.devicePerformPowerAction = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const devicePowerActionActions_1 = require("../../../Front/Device/Power/devicePowerActionActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const socketActionDeliverHelper_1 = require("../../../Socket/socketActionDeliverHelper");
function* devicePerformPowerAction(getNativeDriver, responsibilities, powerPerformer) {
    if (!responsibilities.has(Responsibility_1.default.POWER)) {
        return;
    }
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(devicePowerActions_1.PerformPowerAction, function* ({ powerType, id }) {
        const nativeDriver = getNativeDriver();
        const deviceUid = yield nativeDriver.getDeviceUid();
        try {
            const isSupported = yield isPowerTypeSupported(nativeDriver, powerType);
            if (!isSupported) {
                return;
            }
            yield* (0, socketActionDeliverHelper_1.deliver)({
                type: devicePowerActions_1.PerformPowerActionSucceed,
                id,
                deviceUid,
            });
            const powerActionProcessed = yield powerPerformer.performPowerAction(powerType);
            if (!powerActionProcessed) {
                return;
            }
        }
        catch (error) {
            console.error(error);
            yield (0, effects_1.put)({
                type: devicePowerActions_1.PerformPowerActionFailed,
                id,
                deviceUid,
            });
        }
    });
}
exports.devicePerformPowerAction = devicePerformPowerAction;
function isPowerTypeSupported(nativeDriver, powerType) {
    return __awaiter(this, void 0, void 0, function* () {
        switch (powerType) {
            case PowerActionType_1.default.SYSTEM_REBOOT:
                return yield nativeDriver.managementSupports(ManagementCapability_1.default.SYSTEM_REBOOT);
            case PowerActionType_1.default.APP_RESTART:
                return yield nativeDriver.managementSupports(ManagementCapability_1.default.APP_RESTART);
            case PowerActionType_1.default.DISPLAY_POWER_ON:
            case PowerActionType_1.default.DISPLAY_POWER_OFF:
                return yield nativeDriver.managementSupports(ManagementCapability_1.default.DISPLAY_POWER);
            case PowerActionType_1.default.FILE_SYSTEM_WIPEOUT:
                return yield nativeDriver.managementSupports(ManagementCapability_1.default.FILE_SYSTEM_WIPEOUT);
            default:
                return false;
        }
    });
}
function* devicePerformScheduledPowerAction(powerPerformer) {
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.PerformScheduledPowerAction, function* ({ powerType }) {
        try {
            yield powerPerformer.performPowerAction(powerType);
        }
        catch (error) {
            console.error('devicePerformScheduledPowerAction failed', error);
        }
    });
}
exports.devicePerformScheduledPowerAction = devicePerformScheduledPowerAction;
function* deviceDisplayPowerAction(getNativeDriver) {
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.TriggerDisplayPowerOn, function* () {
        try {
            yield getNativeDriver().displayPowerOn();
        }
        catch (error) {
            console.error('deviceDisplayPowerAction on failed', error);
        }
    });
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.TriggerDisplayPowerOff, function* () {
        try {
            yield getNativeDriver().displayPowerOff();
        }
        catch (error) {
            console.error('deviceDisplayPowerAction off failed', error);
        }
    });
}
exports.deviceDisplayPowerAction = deviceDisplayPowerAction;
//# sourceMappingURL=devicePowerActionSagas.js.map