"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPowerActionInList = exports.checkAndSetPowerActionsScheduleSettings = exports.devicePowerActionPolicySaga = void 0;
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const devicePolicySagas_1 = require("../Policy/devicePolicySagas");
const devicePowerActionTelemetrySagas_1 = require("./devicePowerActionTelemetrySagas");
const Weekday_1 = __importDefault(require("@signageos/actions/dist/Misc/Weekday"));
const effects_1 = require("redux-saga/effects");
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
exports.devicePowerActionPolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.POWER_ACTIONS_SCHEDULE, Responsibility_1.default.SCHEDULED_POWER, ManagementCapability_1.default.SCHEDULE_POWER_ACTION, checkAndSetPowerActionsScheduleSettings);
function checkAndSetPowerActionsScheduleSettings(properties) {
    return __asyncGenerator(this, arguments, function* checkAndSetPowerActionsScheduleSettings_1() {
        let changed = devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED;
        const powerActionsScheduleSettings = properties.policy.value.map((powerAction) => (Object.assign(Object.assign({}, powerAction), { uid: `policy-${powerAction.uid}` })));
        const currentPowerActionsScheduleSettings = yield __await((0, devicePowerActionTelemetrySagas_1.getPowerActionsScheduleSettings)(properties));
        for (let powerAction of powerActionsScheduleSettings) {
            if (!isPowerActionInList(currentPowerActionsScheduleSettings, powerAction)) {
                changed = devicePolicySagas_1.CheckAndSetResult.CHANGED;
                yield yield __await((0, effects_1.put)({
                    type: devicePowerActions_1.SchedulePowerAction,
                    uid: powerAction.uid,
                    powerType: PowerActionType_1.default[powerAction.powerType],
                    weekdays: powerAction.weekdays.map((weekday) => Weekday_1.default[weekday]),
                    time: powerAction.time,
                }));
            }
        }
        for (let powerAction of currentPowerActionsScheduleSettings) {
            if (!isPowerActionInList(powerActionsScheduleSettings, powerAction)) {
                changed = devicePolicySagas_1.CheckAndSetResult.CHANGED;
                yield yield __await((0, effects_1.put)({
                    type: devicePowerActions_1.CancelScheduledPowerAction,
                    scheduledPowerActionUid: powerAction.uid,
                }));
            }
        }
        return yield __await(changed);
    });
}
exports.checkAndSetPowerActionsScheduleSettings = checkAndSetPowerActionsScheduleSettings;
function isPowerActionInList(list, powerAction) {
    return list.some((powerActionInList) => powerActionInList.uid === powerAction.uid);
}
exports.isPowerActionInList = isPowerActionInList;
//# sourceMappingURL=devicePowerActionPolicySagas.js.map