"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDevicePolicySaga = exports.updateDevicePolicy = exports.subscribeDevicePolicy = exports.CheckAndSetResult = void 0;
const effects_1 = require("redux-saga/effects");
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const devicePolicyActions_1 = require("@signageos/actions/dist/Device/Policy/devicePolicyActions");
const Property_1 = __importDefault(require("../../../Property/Property"));
const IPolicyItem_1 = require("@signageos/common-types/dist/Policy/IPolicyItem");
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const asyncCall_1 = __importDefault(require("../../../Util/asyncCall"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const debug_1 = __importDefault(require("debug"));
const responsible_1 = require("../../../Feature/responsible");
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const FailsCount_1 = __importDefault(require("./FailsCount"));
const lodash_1 = __importDefault(require("lodash"));
const deviceTelemetryHelper_1 = require("../Telemetry/deviceTelemetryHelper");
const systemLogs_1 = require("@signageos/common-types/dist/Device/SystemLogs/systemLogs");
const systemLogActionFactory_1 = require("../../../SystemLogs/systemLogActionFactory");
const debug = (0, debug_1.default)('@signageos/front-display:Management:Policy');
const POLICY_ACCEPTABLE_FAILS_COUNT = 5;
var CheckAndSetResult;
(function (CheckAndSetResult) {
    CheckAndSetResult[CheckAndSetResult["NOT_CHANGED"] = 0] = "NOT_CHANGED";
    CheckAndSetResult[CheckAndSetResult["CHANGED"] = 1] = "CHANGED";
})(CheckAndSetResult || (exports.CheckAndSetResult = CheckAndSetResult = {}));
function* subscribeDevicePolicy(responsibilities, getState) {
    if (!responsibilities.has(Responsibility_1.default.POLICY)) {
        return;
    }
    yield (0, socketActionCreator_1.bindAndTakeEvery)([authenticationActions_1.AuthenticationSucceed, deviceVerificationActions_1.VerificationSucceeded], function* (action) {
        try {
            switch (action.type) {
                case authenticationActions_1.AuthenticationSucceed:
                    const state = getState();
                    if (state.deviceVerification.verified) {
                        yield (0, effects_1.put)({
                            type: devicePolicyActions_1.GetDevicePolicyItems,
                        });
                    }
                    break;
                case deviceVerificationActions_1.VerificationSucceeded:
                    yield (0, effects_1.put)({
                        type: devicePolicyActions_1.GetDevicePolicyItems,
                    });
                    break;
                default:
            }
        }
        catch (error) {
            debug('SubscribeDevicePolicy failed', error);
        }
    });
}
exports.subscribeDevicePolicy = subscribeDevicePolicy;
function* updateDevicePolicy(responsibilities, propertyStorage) {
    if (!responsibilities.has(Responsibility_1.default.POLICY)) {
        return;
    }
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(devicePolicyActions_1.UpdateDevicePolicyItems, function* (action) {
        try {
            const currentPolicyItems = yield propertyStorage.getValueOrDefault(Property_1.default.DEVICE_POLICY, []);
            const changedPolicyItems = lodash_1.default.differenceWith(action.items, currentPolicyItems, lodash_1.default.isEqual);
            yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
                type: systemLogs_1.PolicyChanged,
                actual: currentPolicyItems,
                difference: changedPolicyItems,
                updatedAt: new Date().getTime(),
            }));
            yield propertyStorage.setValue(Property_1.default.DEVICE_POLICY, action.items);
            if (action.items.some((item) => (0, IPolicyItem_1.isPolicyItemOfType)(item, DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS))) {
                yield propertyStorage.removeValue(Property_1.default.BRIGHTNESS_SETTINGS);
            }
            for (const proposedPolicyItem of action.items) {
                const currentPolicyItem = currentPolicyItems.find((item) => item.type === proposedPolicyItem.type);
                const isPolicyItemChanged = lodash_1.default.isEqual(currentPolicyItem === null || currentPolicyItem === void 0 ? void 0 : currentPolicyItem.value, proposedPolicyItem.value);
                if (!isPolicyItemChanged) {
                    const failsCount = new FailsCount_1.default(proposedPolicyItem.type, propertyStorage);
                    yield failsCount.reset();
                }
            }
        }
        catch (error) {
            debug('updatePolicy', error);
        }
    });
}
exports.updateDevicePolicy = updateDevicePolicy;
const createDevicePolicySaga = (type, responsibility, requiredCapability, checkAndSetSettings) => (0, responsible_1.whenResponsible)([Responsibility_1.default.POLICY, responsibility], (0, capable_1.whenCapable)(requiredCapability, (0, dependencyInjection_1.withDependencies)([
    'propertyStorage',
    'managementDriver',
    'proprietaryTimerStorage',
    'applicationVersion',
    'staticBaseUrl',
    'telemetryIntervals',
    'powerActionTimer',
], function* ({ propertyStorage, managementDriver, proprietaryTimerStorage: timerStorage, applicationVersion, staticBaseUrl, telemetryIntervals, powerActionTimer, }) {
    var _a;
    const powerActionRules = () => __awaiter(this, void 0, void 0, function* () { return yield powerActionTimer.rules(); });
    const compareItemTypeToLocal = (policyItem) => policyItem.type === type;
    const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals.policy) !== null && _a !== void 0 ? _a : 0;
    yield (0, deviceTelemetryHelper_1.registerTelemetry)('POLICY', periodMs, function* () {
        const failsCount = new FailsCount_1.default(type, propertyStorage);
        let policy;
        try {
            const devicePolicy = yield propertyStorage.getValueOrDefault(Property_1.default.DEVICE_POLICY, []);
            debug('device policy %s enforcement', type);
            const fails = yield failsCount.get();
            if (!devicePolicy.some(compareItemTypeToLocal) || fails > POLICY_ACCEPTABLE_FAILS_COUNT) {
                return;
            }
            policy = devicePolicy.filter(compareItemTypeToLocal).pop();
            debug('policy type %s item: %s', type, JSON.stringify(policy));
            const settingsChanged = yield (0, asyncCall_1.default)(checkAndSetSettings, {
                policy,
                managementDriver,
                propertyStorage,
                timerStorage,
                powerActionRules,
                getStaticBaseUrl: () => staticBaseUrl,
                applicationVersion,
            });
            debug('was policy %s set', type, settingsChanged);
            if (settingsChanged === CheckAndSetResult.CHANGED) {
                yield (0, effects_1.put)({
                    type: devicePolicyActions_1.ApplyPolicySucceeded,
                    name: type,
                });
            }
            if (settingsChanged === CheckAndSetResult.CHANGED) {
                yield failsCount.add();
            }
            else {
                yield failsCount.reset();
            }
        }
        catch (error) {
            yield failsCount.add();
            debug(`checking and setting device policy ${type} failed`, error);
        }
        const finalFails = yield failsCount.get();
        const failThresholdHit = finalFails > POLICY_ACCEPTABLE_FAILS_COUNT;
        if (failThresholdHit && typeof policy !== 'undefined') {
            yield (0, effects_1.put)({
                type: devicePolicyActions_1.ApplyPolicyFailed,
                name: type,
                data: policy,
            });
        }
    });
})));
exports.createDevicePolicySaga = createDevicePolicySaga;
//# sourceMappingURL=devicePolicySagas.js.map