"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
class FailsCount {
    constructor(type, propertyStorage) {
        this.type = type;
        this.propertyStorage = propertyStorage;
        this.propertyKey = (0, deviceTelemetrySagas_1.getPropertyName)(this.type, 'DEVICE_POLICY_FAILS_COUNT');
    }
    get() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.propertyStorage.getValueOrDefault(this.propertyKey, 0);
        });
    }
    reset() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.propertyStorage.setValue(this.propertyKey, 0);
        });
    }
    add() {
        return __awaiter(this, void 0, void 0, function* () {
            const failsCount = yield this.propertyStorage.getValueOrDefault(this.propertyKey, 0);
            yield this.propertyStorage.setValue(this.propertyKey, failsCount + 1);
            return failsCount;
        });
    }
}
exports.default = FailsCount;
//# sourceMappingURL=FailsCount.js.map